/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.util.SFMUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CableNetwork {
    protected final Level LEVEL;
    protected final LongSet CABLE_POSITIONS = new LongOpenHashSet();
    protected final Long2ObjectMap<ICapabilityProvider> CAPABILITY_PROVIDER_POSITIONS = new Long2ObjectOpenHashMap();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    public static boolean isCable(@Nullable Level world, BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.m_8055_(cablePos).m_60734_() instanceof ICableBlock;
    }

    public void rebuildNetwork(BlockPos start) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_PROVIDER_POSITIONS.clear();
        this.discoverCables(start).forEach(this::addCable);
    }

    public void rebuildNetworkFromCache(BlockPos start, CableNetwork cache) {
        this.CABLE_POSITIONS.clear();
        this.CAPABILITY_PROVIDER_POSITIONS.clear();
        List<BlockPos> cables = SFMUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.m_121955_(d.m_122436_());
                if (!cache.containsCablePosition(offset)) continue;
                next.accept(offset);
            }
        }, start).toList();
        for (BlockPos cablePos2 : cables) {
            this.CABLE_POSITIONS.add(cablePos2.m_121878_());
        }
        cables.stream().flatMap(cablePos -> Arrays.stream(Direction.values()).map(Direction::m_122436_).map(arg_0 -> ((BlockPos)cablePos).m_121955_(arg_0))).distinct().filter(pos -> cache.CAPABILITY_PROVIDER_POSITIONS.containsKey(pos.m_121878_())).map(capPos -> Pair.of((Object)capPos, (Object)((ICapabilityProvider)cache.CAPABILITY_PROVIDER_POSITIONS.get(capPos.m_121878_())))).forEach(pair -> this.CAPABILITY_PROVIDER_POSITIONS.put(((BlockPos)pair.getFirst()).m_121878_(), (Object)((ICapabilityProvider)pair.getSecond())));
    }

    public Stream<BlockPos> discoverCables(BlockPos startPos) {
        return SFMUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.m_121955_(d.m_122436_());
                if (!CableNetwork.isCable(this.getLevel(), offset)) continue;
                next.accept(offset);
            }
        }, startPos);
    }

    public void addCable(BlockPos pos) {
        boolean isNewMember = this.CABLE_POSITIONS.add(pos.m_121878_());
        if (isNewMember) {
            this.rebuildAdjacentInventories(pos);
        }
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public void rebuildAdjacentInventories(BlockPos cablePos) {
        Arrays.stream(Direction.values()).map(Direction::m_122436_).map(arg_0 -> ((BlockPos)cablePos).m_121955_(arg_0)).distinct().peek(pos -> this.CAPABILITY_PROVIDER_POSITIONS.remove(pos.m_121878_())).filter(this::isAdjacentToCable).map(pos -> SFMUtils.discoverCapabilityProvider((LevelAccessor)this.LEVEL, pos).map(prov -> Pair.of((Object)pos, (Object)prov))).filter(Optional::isPresent).map(Optional::get).forEach(prov -> this.CAPABILITY_PROVIDER_POSITIONS.put(((BlockPos)prov.getFirst()).m_121878_(), (Object)((ICapabilityProvider)prov.getSecond())));
    }

    public String toString() {
        return "CableNetwork{level=" + this.getLevel().m_46472_().m_135782_() + ", #cables=" + this.getCableCount() + ", #capabilityProviders=" + this.CAPABILITY_PROVIDER_POSITIONS.size() + "}";
    }

    public boolean isAdjacentToCable(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.containsCablePosition(pos.m_121955_(direction.m_122436_()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsCablePosition(BlockPos pos) {
        return this.CABLE_POSITIONS.contains(pos.m_121878_());
    }

    public boolean isInNetwork(BlockPos pos) {
        return this.CAPABILITY_PROVIDER_POSITIONS.containsKey(pos.m_121878_());
    }

    public Optional<ICapabilityProvider> getCapabilityProvider(BlockPos pos) {
        return Optional.ofNullable((ICapabilityProvider)this.CAPABILITY_PROVIDER_POSITIONS.get(pos.m_121878_()));
    }

    public int getCableCount() {
        return this.CABLE_POSITIONS.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLE_POSITIONS.addAll((LongCollection)other.CABLE_POSITIONS);
        this.CAPABILITY_PROVIDER_POSITIONS.putAll(other.CAPABILITY_PROVIDER_POSITIONS);
    }

    public boolean isEmpty() {
        return this.CABLE_POSITIONS.isEmpty();
    }

    public Stream<BlockPos> getCablePositions() {
        return this.CABLE_POSITIONS.longStream().mapToObj(BlockPos::m_122022_);
    }

    public Stream<BlockPos> getCapabilityProviderPositions() {
        return this.CAPABILITY_PROVIDER_POSITIONS.keySet().longStream().mapToObj(BlockPos::m_122022_);
    }

    protected List<CableNetwork> withoutCable(BlockPos cablePos) {
        this.CABLE_POSITIONS.remove(cablePos.m_121878_());
        ArrayList<CableNetwork> branches = new ArrayList<CableNetwork>();
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = cablePos.m_121955_(direction.m_122436_());
            if (!this.containsCablePosition(offsetPos) || branches.stream().anyMatch(n -> n.containsCablePosition(offsetPos))) continue;
            CableNetwork branchNetwork = new CableNetwork(this.getLevel());
            branchNetwork.rebuildNetworkFromCache(offsetPos, this);
            branches.add(branchNetwork);
        }
        return branches;
    }
}

