/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.jei;

import ca.teamdman.sfm.client.jei.FallingAnvilDisenchantRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilExperienceShardRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilFormRecipe;
import ca.teamdman.sfm.client.jei.FallingAnvilRecipe;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class FallingAnvilJEICategory
implements IRecipeCategory<FallingAnvilRecipe> {
    public static final RecipeType<FallingAnvilRecipe> RECIPE_TYPE = RecipeType.create((String)"sfm", (String)"falling_anvil", FallingAnvilRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FallingAnvilJEICategory(IJeiHelpers jeiHelpers) {
        this.background = jeiHelpers.getGuiHelper().createBlankDrawable(80, 54);
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50322_));
    }

    public RecipeType<FallingAnvilRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Constants.LocalizationKeys.FALLING_ANVIL_JEI_CATEGORY_TITLE.getComponent();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FallingAnvilRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> anvil = List.of(new ItemStack((ItemLike)Items.f_42146_), new ItemStack((ItemLike)Items.f_42147_), new ItemStack((ItemLike)Items.f_42148_));
        if (recipe instanceof FallingAnvilFormRecipe) {
            FallingAnvilFormRecipe formRecipe = (FallingAnvilFormRecipe)recipe;
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(formRecipe.PARENT.FORM);
            ItemStack ironBlock = new ItemStack((ItemLike)Blocks.f_50075_);
            CompoundTag displayTag = ironBlock.m_41784_().m_128469_("display");
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Constants.LocalizationKeys.FALLING_ANVIL_JEI_CONSUMED.getComponent())));
            displayTag.m_128365_("Lore", (Tag)lore);
            ironBlock.m_41784_().m_128365_("display", (Tag)displayTag);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(ironBlock);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(Arrays.stream(formRecipe.PARENT.FORM.m_43908_()).map(FormItem::getForm).toList());
        } else if (recipe instanceof FallingAnvilDisenchantRecipe) {
            Collection enchants = ForgeRegistries.ENCHANTMENTS.getValues();
            List<Item> tools = List.of(Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42390_, Items.f_42389_, Items.f_42391_, Items.f_42392_, Items.f_42388_, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42432_, Items.f_42431_, Items.f_42433_, Items.f_42434_, Items.f_42430_, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_, Items.f_42385_, Items.f_42384_, Items.f_42386_, Items.f_42387_, Items.f_42383_, Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_, Items.f_42422_, Items.f_42421_, Items.f_42423_, Items.f_42424_, Items.f_42420_, Items.f_42411_);
            ArrayList<ItemStack> enchanted = new ArrayList<ItemStack>();
            ArrayList<ItemStack> books = new ArrayList<ItemStack>();
            for (Enchantment enchant : enchants) {
                for (Item tool : tools) {
                    ItemStack stack = new ItemStack((ItemLike)tool);
                    if (!enchant.m_6081_(stack)) continue;
                    stack.m_41663_(enchant, enchant.m_6586_());
                    enchanted.add(stack);
                    books.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchant, enchant.m_6586_())));
                }
            }
            builder.addSlot(RecipeIngredientRole.CATALYST, 8, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addItemStacks(enchanted);
            builder.addSlot(RecipeIngredientRole.INPUT, 18, 18).addItemStack(new ItemStack((ItemLike)Items.f_42517_));
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.f_50080_);
            CompoundTag displayTag = obsidian.m_41784_().m_128469_("display");
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Constants.LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent())));
            displayTag.m_128365_("Lore", (Tag)lore);
            obsidian.m_41784_().m_128365_("display", (Tag)displayTag);
            builder.addSlot(RecipeIngredientRole.INPUT, 8, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStacks(books);
        } else if (recipe instanceof FallingAnvilExperienceShardRecipe) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 0, 0).addItemStacks(anvil);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 18).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42690_}));
            ItemStack obsidian = new ItemStack((ItemLike)Blocks.f_50080_);
            CompoundTag displayTag = obsidian.m_41784_().m_128469_("display");
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Constants.LocalizationKeys.FALLING_ANVIL_JEI_NOT_CONSUMED.getComponent())));
            displayTag.m_128365_("Lore", (Tag)lore);
            obsidian.m_41784_().m_128365_("display", (Tag)displayTag);
            builder.addSlot(RecipeIngredientRole.INPUT, 0, 36).addItemStack(obsidian);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 18).addItemStack(new ItemStack((ItemLike)SFMItems.EXPERIENCE_SHARD_ITEM.get()));
        }
    }
}

