/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.client.gui.screen.ProgramTemplatePickerScreen;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class ManagerScreen
extends AbstractContainerScreen<ManagerContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("sfm", "textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.m_237119_();
    private float statusCountdown = 0.0f;
    private ExtendedButton diagButton;
    private ExtendedButton clipboardPasteButton;
    private ExtendedButton clipboardCopyButton;
    private ExtendedButton resetButton;
    private ExtendedButton editButton;
    private ExtendedButton examplesButton;

    public List<ExtendedButton> getButtonsForJEIExclusionZones() {
        return List.of(this.clipboardPasteButton, this.editButton, this.examplesButton, this.clipboardCopyButton);
    }

    public ManagerScreen(ManagerContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_5833_();
    }

    public void updateVisibilities() {
        boolean diskPresent = ((ManagerContainerMenu)this.f_97732_).m_38853_(0).m_6657_();
        this.diagButton.f_93624_ = this.shouldShowDiagButton();
        this.clipboardCopyButton.f_93624_ = diskPresent;
        this.clipboardPasteButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.resetButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.editButton.f_93624_ = diskPresent && !this.isReadOnly();
    }

    private Button.OnTooltip buildTooltip(Constants.LocalizationKeys.LocalizationEntry entry) {
        return (btn, pose, mx, my) -> this.m_96617_(pose, this.f_96547_.m_92923_((FormattedText)entry.getComponent(), Math.max(this.f_96543_ / 2 - 43, 170)), mx, my);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 120;
        this.clipboardPasteButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16, buttonWidth, 16, (Component)Constants.LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON.getComponent(), button -> this.onLoadClipboard(), this.buildTooltip(Constants.LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP)));
        this.editButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16 + 50, buttonWidth, 16, (Component)Constants.LocalizationKeys.MANAGER_GUI_EDIT_BUTTON.getComponent(), button -> this.onEdit(), this.buildTooltip(Constants.LocalizationKeys.MANAGER_GUI_EDIT_BUTTON_TOOLTIP)));
        this.examplesButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 32 + 50, buttonWidth, 16, (Component)Constants.LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON.getComponent(), button -> this.onShowExamples(), this.buildTooltip(Constants.LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP)));
        this.clipboardCopyButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 128, buttonWidth, 16, (Component)Constants.LocalizationKeys.MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON.getComponent(), button -> this.onSaveClipboard()));
        this.resetButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 + 120, (this.f_96544_ - this.f_97727_) / 2 + 10, 50, 12, (Component)Constants.LocalizationKeys.MANAGER_GUI_RESET_BUTTON.getComponent(), button -> this.sendReset(), this.buildTooltip(Constants.LocalizationKeys.MANAGER_GUI_RESET_BUTTON_TOOLTIP)));
        this.diagButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 + 35, (this.f_96544_ - this.f_97727_) / 2 + 48, 12, 14, (Component)Component.m_237113_((String)"!"), button -> {
            if (Screen.m_96638_() && !this.isReadOnly()) {
                this.sendAttemptFix();
            } else {
                this.onSaveDiagClipboard();
            }
        }, this.buildTooltip(this.isReadOnly() ? Constants.LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY : Constants.LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP)));
        this.updateVisibilities();
    }

    private void onEdit() {
        ClientStuff.showProgramEditScreen(((ManagerContainerMenu)this.f_97732_).CONTAINER.m_8020_(0), this::sendProgram);
    }

    private void onShowExamples() {
        Minecraft.m_91087_().pushGuiLayer((Screen)new ProgramTemplatePickerScreen(template -> ClientStuff.showProgramEditScreen(template, this::sendProgram)));
    }

    private void sendReset() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerResetPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = Constants.LocalizationKeys.MANAGER_GUI_STATUS_RESET.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendAttemptFix() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerFixPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = Constants.LocalizationKeys.MANAGER_GUI_STATUS_FIX.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerProgramPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION, program));
        ((ManagerContainerMenu)this.f_97732_).program = program;
        this.status = Constants.LocalizationKeys.MANAGER_GUI_STATUS_LOADED_CLIPBOARD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onSaveClipboard() {
        try {
            Minecraft.m_91087_().f_91068_.m_90911_(((ManagerContainerMenu)this.f_97732_).program);
            this.status = Constants.LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed to save clipboard", t);
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerContainerMenu)this.f_97732_).CONTAINER.m_8020_(0);
        if (!(disk.m_41720_() instanceof DiskItem)) {
            return false;
        }
        List<TranslatableContents> errors = DiskItem.getErrors(disk);
        List<TranslatableContents> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagClipboard() {
        try {
            List<TranslatableContents> warnings;
            ItemStack disk = ((ManagerContainerMenu)this.f_97732_).CONTAINER.m_8020_(0);
            if (!(disk.m_41720_() instanceof DiskItem)) {
                return;
            }
            StringBuilder content = new StringBuilder(((ManagerContainerMenu)this.f_97732_).program);
            content.append("\n\n-- Diagnostic info ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm.ss").format(new Date())).append(" --");
            List<TranslatableContents> errors = DiskItem.getErrors(disk);
            if (!errors.isEmpty()) {
                content.append("\n\n-- Errors\n");
                for (TranslatableContents error : errors) {
                    content.append("-- * ").append(I18n.m_118938_((String)error.m_237508_(), (Object[])error.m_237523_())).append("\n");
                }
            }
            if (!(warnings = DiskItem.getWarnings(disk)).isEmpty()) {
                content.append("\n\n-- Warnings\n");
                for (TranslatableContents warning : warnings) {
                    content.append("-- * ").append(I18n.m_118938_((String)warning.m_237508_(), (Object[])warning.m_237523_())).append("\n");
                }
            }
            Minecraft.m_91087_().f_91068_.m_90911_(content.toString());
            this.status = Constants.LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed saving clipboard", t);
        }
    }

    private void onLoadClipboard() {
        try {
            String contents = Minecraft.m_91087_().f_91068_.m_90876_();
            this.sendProgram(contents);
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed loading clipboard", t);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.m_96630_((int)pKeyCode) && this.clipboardPasteButton.f_93624_) {
            this.onLoadClipboard();
            return true;
        }
        if (Screen.m_96632_((int)pKeyCode) && this.clipboardCopyButton.f_93624_) {
            this.onSaveClipboard();
            return true;
        }
        if (pKeyCode == 69 && Screen.m_96637_() && Screen.m_96638_() && this.examplesButton.f_93624_) {
            this.onShowExamples();
            return true;
        }
        if (pKeyCode == 69 && Screen.m_96637_() && this.editButton.f_93624_) {
            this.onEdit();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    protected void m_7027_(PoseStack poseStack, int mx, int my) {
        super.m_7027_(poseStack, mx, my);
        ManagerBlockEntity.State state = ((ManagerContainerMenu)this.f_97732_).state;
        this.f_96547_.m_92889_(poseStack, (Component)Constants.LocalizationKeys.MANAGER_GUI_STATE.getComponent(state.LOC.getComponent().m_130940_(state.COLOR)), (float)this.f_97728_, 20.0f, 0);
        if (this.statusCountdown > 0.0f) {
            this.f_96547_.m_92889_(poseStack, this.status, (float)(this.f_97730_ + this.f_96547_.m_92895_(this.f_169604_.getString()) + 5), (float)this.f_97731_, 0);
        }
        long peakTickTimeNanoseconds = 0L;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            peakTickTimeNanoseconds = Long.max(peakTickTimeNanoseconds, ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i]);
        }
        long yMax = Long.max(peakTickTimeNanoseconds, 50000000L);
        int plotX = this.f_97728_ + 45;
        int plotY = 40;
        int spaceBetweenPoints = 6;
        int plotWidth = 6 * (((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length - 1);
        int plotHeight = 30;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_85982_(pose, (float)(plotX + plotWidth), 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_85982_(pose, (float)(plotX + plotWidth), 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_85982_(pose, (float)plotX, 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_85982_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        tesselator.m_85914_();
        bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        int mouseTickTimeIndex = -1;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            long y = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i];
            float normalizedTickTime = y == 0L ? 0.0f : (float)(Math.log10(y) / Math.log10(yMax));
            int plotPosY = 70 - (int)(normalizedTickTime * 30.0f);
            int plotPosX = plotX + 6 * i;
            ChatFormatting c = this.getMillisecondColour((float)y / 1000000.0f);
            float red = (float)(c.m_126665_() >> 16 & 0xFF) / 255.0f;
            float green = (float)(c.m_126665_() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(c.m_126665_() & 0xFF) / 255.0f;
            bufferbuilder.m_85982_(pose, (float)plotPosX, (float)plotPosY, (float)this.m_93252_()).m_85950_(red, green, blue, 1.0f).m_5752_();
            if (mx - this.f_97735_ < plotPosX - 3 || mx - this.f_97735_ > plotPosX + 3 || my - this.f_97736_ < 38 || my - this.f_97736_ > 72) continue;
            mouseTickTimeIndex = i;
        }
        tesselator.m_85914_();
        DecimalFormat format = new DecimalFormat("0.000");
        if (mouseTickTimeIndex != -1) {
            long hoveredTickTimeNanoseconds = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[mouseTickTimeIndex];
            float hoveredTickTimeMilliseconds = (float)hoveredTickTimeNanoseconds / 1000000.0f;
            MutableComponent mutableComponent = Constants.LocalizationKeys.MANAGER_GUI_HOVERED_TICK_TIME.getComponent(Component.m_237113_((String)format.format(hoveredTickTimeMilliseconds)).m_130940_(this.getMillisecondColour(hoveredTickTimeMilliseconds)));
            float f = this.f_97728_;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(poseStack, (Component)mutableComponent, f, 20.0f + 9.0f + 0.1f, 0);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            tesselator = Tesselator.m_85913_();
            bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            pose = poseStack.m_85850_().m_85861_();
            int x = plotX + 6 * mouseTickTimeIndex;
            bufferbuilder.m_85982_(pose, (float)x, 40.0f, (float)this.m_93252_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            bufferbuilder.m_85982_(pose, (float)x, 70.0f, (float)this.m_93252_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
        } else {
            float peakTickTimeMilliseconds = (float)peakTickTimeNanoseconds / 1000000.0f;
            MutableComponent mutableComponent = Constants.LocalizationKeys.MANAGER_GUI_PEAK_TICK_TIME.getComponent(Component.m_237113_((String)format.format(peakTickTimeMilliseconds)).m_130940_(this.getMillisecondColour(peakTickTimeMilliseconds)));
            float f = this.f_97728_;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(poseStack, (Component)mutableComponent, f, 20.0f + 9.0f + 0.1f, 0);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public ChatFormatting getMillisecondColour(float ms) {
        if (ms <= 5.0f) {
            return ChatFormatting.GREEN;
        }
        if (ms <= 15.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mx, my, partialTicks);
        this.m_7025_(poseStack, mx, my);
        this.updateVisibilities();
        this.statusCountdown -= partialTicks;
    }

    protected void m_7025_(PoseStack pose, int mx, int my) {
        super.m_7025_(pose, mx, my);
        this.f_169369_.stream().filter(ExtendedButtonWithTooltip.class::isInstance).map(ExtendedButtonWithTooltip.class::cast).forEach(x -> x.m_7428_(pose, mx, my));
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mx, int my) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE_LOCATION);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }
}

