/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.config;

import com.mrbysco.structurecompass.StructureCompass;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class StructureConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        StructureCompass.LOGGER.debug("Loaded Structure Compass' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        StructureCompass.LOGGER.warn("Structure Compass' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue compassRange;
        public final ForgeConfigSpec.BooleanValue locateUnexplored;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> structureBlacklist;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.compassRange = builder.comment("Sets the range in blocks in which the structure compasses can locate structures [default: 10000]").defineInRange("compassRange", 10000, 0, Integer.MAX_VALUE);
            this.locateUnexplored = builder.comment("Defines if the structure compass should locate unexplored structures [default: false]").define("locateUnexplored", false);
            this.structureBlacklist = builder.comment("Defines which structures can't be searched with the Structure Compass\n(Supports wildcard *, Example: 'minecraft:*' will blacklist anything in the minecraft domain)").defineListAllowEmpty(List.of("structureBlacklist"), () -> List.of(""), o -> o instanceof String);
            builder.pop();
        }
    }
}

