/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightUpdater;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IGetBezierConnection;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackInstance;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TrackInstance.class}, remap=false)
public abstract class MixinTrackInstance
extends BlockEntityInstance<TrackBlockEntity>
implements IGetBezierConnection {
    @Nullable
    private BezierConnection bezierConnection = null;
    private final List<Pair<ModelData, BlockPos>> casingData = new ArrayList<Pair<ModelData, BlockPos>>();

    private MixinTrackInstance(MaterialManager materialManager, TrackBlockEntity blockEntity) {
        super(materialManager, (BlockEntity)blockEntity);
    }

    @Shadow
    public abstract void remove();

    @Override
    @Nullable
    public BezierConnection getBezierConnection() {
        return this.bezierConnection;
    }

    @Inject(method={"createInstance"}, at={@At(value="HEAD")})
    private void preCreateInstance(BezierConnection bc, CallbackInfoReturnable<?> cir) {
        this.bezierConnection = bc;
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=0)})
    private void updateWithoutConnections(CallbackInfo ci) {
        this.remove();
        this.makeCasingData(false);
        LightUpdater.get((LevelAccessor)this.world).addListener((LightListener)this);
    }

    @Inject(method={"update"}, at={@At(value="RETURN", ordinal=1)})
    private void updateWithConnections(CallbackInfo ci) {
        this.makeCasingData(true);
    }

    @Inject(method={"updateLight"}, at={@At(value="HEAD")})
    private void snr_updateLight(CallbackInfo ci) {
        this.casingData.forEach(data -> ((ModelData)data.getFirst()).updateLight((BlockAndTintGetter)this.world, (BlockPos)data.getSecond()));
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void snr_remove(CallbackInfo ci) {
        this.casingData.forEach(data -> ((ModelData)data.getFirst()).delete());
        this.casingData.clear();
    }

    @Inject(method={"getVolume"}, at={@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void snr_getVolume(CallbackInfoReturnable<GridAlignedBB> cir, List<BlockPos> out) {
        out.add(this.pos);
    }

    private void makeCasingData(boolean connections) {
        TrackShape shape;
        Material mat = this.materialManager.cutout(RenderType.m_110457_()).material(Materials.TRANSFORMED);
        PoseStack ms = new PoseStack();
        ((TransformStack)TransformStack.cast((PoseStack)ms).translate((Vec3i)this.getInstancePosition())).nudge((int)this.pos.m_121878_());
        SlabBlock casingBlock = ((IHasTrackCasing)this.blockEntity).getTrackCasing();
        if (casingBlock != null && CRBlockPartials.TRACK_CASINGS.containsKey(shape = (TrackShape)this.blockState.m_61143_((Property)TrackBlock.SHAPE))) {
            ms.m_85836_();
            if (((TrackBlockEntity)this.blockEntity).isTilted()) {
                double angle = (Double)((TrackBlockEntity)this.blockEntity).tilt.smoothingAngle.get();
                switch ((TrackShape)((TrackBlockEntity)this.blockEntity).m_58900_().m_61143_((Property)TrackBlock.SHAPE)) {
                    case ZO: {
                        TransformStack.cast((PoseStack)ms).rotateX(-angle);
                        break;
                    }
                    case XO: {
                        TransformStack.cast((PoseStack)ms).rotateZ(angle);
                    }
                }
            }
            CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
            if (((IHasTrackCasing)this.blockEntity).isAlternate()) {
                spec = spec.getAltSpec();
            }
            PartialModel rawCasingModel = spec.model;
            CRBlockPartials.ModelTransform transform = spec.transform;
            ModelData casingInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, (Material<ModelData>)mat);
            ((ModelData)((ModelData)((ModelData)casingInstance.setTransform(ms).rotateX((double)transform.rx())).rotateY((double)transform.ry())).rotateZ((double)transform.rz())).translate(transform.x(), transform.y(), transform.z());
            casingInstance.updateLight((BlockAndTintGetter)this.world, this.pos);
            this.casingData.add((Pair<ModelData, BlockPos>)Pair.of((Object)casingInstance, (Object)this.pos));
            for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                ModelData additionalInstance = CasingRenderUtils.makeCasingInstance(rawCasingModel, casingBlock, (Material<ModelData>)mat);
                ((ModelData)((ModelData)((ModelData)additionalInstance.setTransform(ms).rotateX((double)additionalTransform.rx())).rotateY((double)additionalTransform.ry())).rotateZ((double)additionalTransform.rz())).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z());
                additionalInstance.updateLight((BlockAndTintGetter)this.world, this.pos);
                this.casingData.add((Pair<ModelData, BlockPos>)Pair.of((Object)additionalInstance, (Object)this.pos.m_7637_(additionalTransform.x(), additionalTransform.y(), additionalTransform.z())));
            }
            ms.m_85849_();
        }
        if (connections) {
            for (BezierConnection bc : ((TrackBlockEntity)this.blockEntity).getConnections().values()) {
                double shiftDown;
                if (!bc.isPrimary() || (casingBlock = ((IHasTrackCasing)bc).getTrackCasing()) == null) continue;
                int heightDiff = Math.abs(((BlockPos)bc.tePositions.get(false)).m_123342_() - ((BlockPos)bc.tePositions.get(true)).m_123342_());
                double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
                if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
                    for (Vec3 pos : CasingRenderUtils.casingPositions(bc)) {
                        ModelData casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                        casingInstance.setTransform(ms).translate(0.0, shiftDown, 0.0).translate(pos.f_82479_, pos.f_82480_, pos.f_82481_).scale(1.001f);
                        BlockPos relativePos = new BlockPos((double)this.pos.m_123341_() + pos.f_82479_, (double)this.pos.m_123342_() + pos.f_82480_, (double)this.pos.m_123343_() + pos.f_82481_);
                        casingInstance.updateLight((BlockAndTintGetter)this.world, relativePos);
                        this.casingData.add((Pair<ModelData, BlockPos>)Pair.of((Object)casingInstance, (Object)relativePos));
                    }
                    continue;
                }
                BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
                for (int i = 1; i < segments.length; ++i) {
                    if (i % 2 == 0) continue;
                    BezierConnection.SegmentAngles segment = segments[i];
                    Matrix4f pose_matrix = segment.tieTransform.m_85861_().m_27658_();
                    pose_matrix.m_27648_(new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                    ModelData casingInstance = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                    casingInstance.setTransform(ms).mulPose(pose_matrix).mulNormal(segment.tieTransform.m_85864_()).translate(0.0, shiftDown, 0.0).scale(1.001f);
                    BlockPos relativePos = segment.lightPosition.m_121955_((Vec3i)this.pos);
                    casingInstance.updateLight((BlockAndTintGetter)this.world, relativePos);
                    this.casingData.add((Pair<ModelData, BlockPos>)Pair.of((Object)casingInstance, (Object)relativePos));
                    for (boolean first : Iterate.trueAndFalse) {
                        PoseStack.Pose transform = (PoseStack.Pose)segment.railTransforms.get(first);
                        Matrix4f pose_matrix2 = transform.m_85861_().m_27658_();
                        pose_matrix2.m_27648_(new Vector3f(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                        ModelData casingInstance2 = CasingRenderUtils.makeCasingInstance(heightDiff == 0 ? CRBlockPartials.TRACK_CASING_FLAT : CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock, (Material<ModelData>)mat);
                        casingInstance2.setTransform(ms).mulPose(pose_matrix2).mulNormal(transform.m_85864_()).translate(-0.5, shiftDown, 0.0);
                        BlockPos relativePos2 = segment.lightPosition.m_121955_((Vec3i)this.pos);
                        casingInstance2.updateLight((BlockAndTintGetter)this.world, relativePos2);
                        this.casingData.add((Pair<ModelData, BlockPos>)Pair.of((Object)casingInstance2, (Object)relativePos2));
                    }
                }
            }
        }
    }
}

