/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.schedule;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;

public class SmartBrainSchedule
extends Schedule {
    private final Type type;
    private final Int2ObjectArrayMap<Activity> timeline = new Int2ObjectArrayMap(0);
    private final ListMultimap<Integer, Consumer<LivingEntity>> callbacks = MultimapBuilder.hashKeys((int)0).arrayListValues().build();
    private boolean sortedTimeline = true;

    public SmartBrainSchedule() {
        this(Type.DAYTIME);
    }

    public SmartBrainSchedule(Type type) {
        this.type = type;
    }

    public SmartBrainSchedule activityAt(int tick, Activity activity) {
        this.timeline.put(tick, (Object)activity);
        this.sortedTimeline = false;
        return this;
    }

    public SmartBrainSchedule doAt(int tick, Consumer<LivingEntity> callback) {
        this.callbacks.put((Object)tick, callback);
        return this;
    }

    public void scheduleTask(LivingEntity brainOwner, int delay, Consumer<LivingEntity> task) {
        this.callbacks.put((Object)this.type.resolveDelay(brainOwner, delay), entity -> task.accept(brainOwner));
    }

    public void clearSchedule() {
        this.callbacks.clear();
        this.timeline.clear();
    }

    @Nullable
    public Activity tick(LivingEntity brainOwner) {
        int tick = this.type.resolve(brainOwner);
        if (!this.callbacks.isEmpty()) {
            this.callbacks.get((Object)tick).forEach(consumer -> consumer.accept(brainOwner));
            if (this.type == Type.AGE) {
                this.callbacks.removeAll((Object)tick);
            }
        }
        if (!this.timeline.isEmpty()) {
            if (!this.sortedTimeline) {
                this.sortTimeline();
            }
            int index = -1;
            Activity activity = null;
            for (Int2ObjectMap.Entry entry : this.timeline.int2ObjectEntrySet()) {
                ++index;
                if (entry.getIntKey() >= tick) {
                    if (entry.getIntKey() != tick) break;
                    activity = (Activity)entry.getValue();
                    break;
                }
                activity = (Activity)entry.getValue();
            }
            if (this.type == Type.AGE && index + 1 >= this.timeline.size()) {
                this.timeline.clear();
            }
            return activity;
        }
        return null;
    }

    private void sortTimeline() {
        Int2ObjectArrayMap copy = new Int2ObjectArrayMap(this.timeline);
        int[] keys = copy.keySet().toArray(new int[0]);
        Arrays.sort(keys);
        this.timeline.clear();
        for (int key : keys) {
            this.timeline.put(key, (Object)((Activity)copy.get(key)));
        }
        this.sortedTimeline = true;
    }

    public final Activity m_38019_(int tick) {
        if (this.type == Type.AGE) {
            return Activity.f_37979_;
        }
        Activity activity = Activity.f_37979_;
        for (Int2ObjectMap.Entry entry : this.timeline.int2ObjectEntrySet()) {
            if (entry.getIntKey() >= tick) {
                return activity;
            }
            activity = (Activity)entry.getValue();
        }
        return activity;
    }

    public static enum Type {
        DAYTIME(e -> (int)(e.f_19853_.m_46468_() % 24000L), (e, t) -> (int)((e.f_19853_.m_46468_() + (long)t.intValue()) % 24000L)),
        AGE(e -> e.f_19797_, (e, t) -> e.f_19797_ + t);

        final ToIntFunction<LivingEntity> tickResolver;
        final ToIntBiFunction<LivingEntity, Integer> delayResolver;

        private Type(ToIntFunction<LivingEntity> tickResolver, ToIntBiFunction<LivingEntity, Integer> delayResolver) {
            this.tickResolver = tickResolver;
            this.delayResolver = delayResolver;
        }

        public int resolve(LivingEntity entity) {
            return this.tickResolver.applyAsInt(entity);
        }

        public int resolveDelay(LivingEntity entity, int delay) {
            return this.delayResolver.applyAsInt(entity, delay);
        }
    }
}

