/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.network;

import java.util.function.Supplier;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketShrink {
    private final CompoundTag nbt;
    private final int entityID;

    public PacketShrink(int entityID, CompoundTag nbt) {
        this.nbt = nbt;
        this.entityID = entityID;
    }

    public static void encode(PacketShrink msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityID);
        buf.m_130079_(msg.nbt);
    }

    public static PacketShrink decode(FriendlyByteBuf buf) {
        return new PacketShrink(buf.readInt(), buf.m_130260_());
    }

    public static class Handler {
        public static void handle(PacketShrink message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity;
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world != null && (entity = world.m_6815_(message.entityID)) instanceof LivingEntity) {
                    entity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                        iShrinkProvider.deserializeNBT((Tag)message.nbt);
                        entity.m_6210_();
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

