/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.registry;

import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryExtension<T, E> {
    public final ResourceKey<? extends Registry<T>> registry;
    public final ResourceKey<? extends Registry<E>> extendedRegistry;
    private final Map<T, Holder<E>> extendedElements;

    public RegistryExtension(ResourceKey<? extends Registry<T>> registry, ResourceKey<? extends Registry<E>> extendedRegistry) {
        this.registry = registry;
        this.extendedRegistry = extendedRegistry;
        this.extendedElements = new HashMap<T, Holder<E>>();
    }

    public void extendsWith(T element, Holder<E> extendedFrom) {
        if (this.extendedElements.containsKey(element)) {
            throw new IllegalArgumentException("Element was assigned an extension source twice: " + element);
        }
        this.extendedElements.put(element, extendedFrom);
    }

    public boolean hasElement(T element) {
        return this.extendedElements.containsKey(element);
    }

    public void loadIds(WritableRegistry<T> registry, Registry<E> sourceRegistry) {
        for (Map.Entry<T, Holder<E>> entry : this.extendedElements.entrySet()) {
            ResourceLocation id;
            T element = entry.getKey();
            Holder<E> extendedFrom = entry.getValue();
            switch (extendedFrom.m_203376_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DIRECT: {
                    ResourceLocation resourceLocation = sourceRegistry.m_7981_(extendedFrom.m_203334_());
                    break;
                }
                case REFERENCE: {
                    ResourceLocation resourceLocation = id = ((Holder.Reference)extendedFrom).m_205785_().m_135782_();
                }
            }
            if (id == null) {
                throw new IllegalStateException("Can't assign id to extended registry element: Source not present in registry: " + extendedFrom);
            }
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
            if (registry.m_7981_(element) != null) {
                throw new IllegalStateException("Can't assign id to extended registry element: Already registered as " + registry.m_7981_(element) + ": " + element);
            }
            registry.m_203505_(key, element, Lifecycle.stable());
        }
    }
}

