/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.registry.WorldGenRegistries;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.mod.ModX;

public abstract class WorldGenProviderBase
implements DataProvider {
    private final ModX mod;
    private final DataGenerator generator;
    private final WorldGenRegistries registries;
    private final ExistingFileHelper fileHelper;
    private final Map<Class<? extends WorldGenData>, WorldGenData> data;

    public WorldGenProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        this.mod = mod;
        this.generator = generator;
        this.registries = new WorldGenRegistries();
        this.fileHelper = fileHelper;
        this.data = new HashMap<Class<? extends WorldGenData>, WorldGenData>();
        generator.m_236039_(true, new DataProvider(){

            @Nonnull
            public String m_6055_() {
                return WorldGenProviderBase.this.m_6055_() + " Implementation";
            }

            public void m_213708_(@Nonnull CachedOutput cache) throws IOException {
                WorldGenProviderBase.this.doRun(cache);
            }
        });
        this.addAdditionalProviders(mod, generator, fileHelper, this.registries);
    }

    protected void addAdditionalProviders(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper, WorldGenRegistries registries) {
    }

    protected abstract void setup();

    public <T extends WorldGenData> void addData(Function<WorldGenData.Properties, T> factory) {
        WorldGenData data = (WorldGenData)factory.apply(new WorldGenData.Properties(this.mod, this, this.registries, this.fileHelper));
        Class<?> cls = data.getClass();
        if (this.data.containsKey(cls)) {
            throw new IllegalArgumentException("Duplicate world gen data: " + cls);
        }
        this.data.put(cls, data);
    }

    public <T extends WorldGenData> T getData(Class<T> cls) {
        if (this.data.containsKey(cls)) {
            return (T)this.data.get(cls);
        }
        throw new NoSuchElementException("World gen data not present: " + cls);
    }

    @Nonnull
    public String m_6055_() {
        return this.mod + " world gen";
    }

    public void m_213708_(@Nonnull CachedOutput cache) throws IOException {
    }

    private void doRun(@Nonnull CachedOutput cache) throws IOException {
        this.setup();
        for (WorldGenData entry : this.data.values()) {
            this.setupAutoIds(entry);
        }
        this.registries.freezeAll();
        List results = this.data.values().stream().map(WorldGenData::results).flatMap(Collection::stream).toList();
        for (WorldGenData.Result result : results) {
            this.writeResult(cache, result);
        }
    }

    private void setupAutoIds(WorldGenData data) throws IOException {
        try {
            for (Field field : data.getClass().getDeclaredFields()) {
                Holder.Reference ref;
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !Holder.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Holder holder = (Holder)field.get(data);
                if (holder.m_203376_() != Holder.Kind.REFERENCE || !(holder instanceof Holder.Reference) || (ref = (Holder.Reference)holder).getType() != Holder.Reference.Type.INTRUSIVE) continue;
                StringBuilder id = new StringBuilder();
                for (char chr : field.getName().toCharArray()) {
                    if (Character.isUpperCase(chr)) {
                        id.append("_");
                    }
                    id.append(Character.toString(chr).toLowerCase(Locale.ROOT));
                }
                this.registries.assignId(ref.f_205748_.m_123023_(), this.mod.resource(id.toString()), holder.m_203334_());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }

    private <T> void writeResult(CachedOutput cache, WorldGenData.Result<T> result) throws IOException {
        DynamicOps ops = this.registries.dynamicOps(JsonOps.INSTANCE);
        Codec<T> codec = result.codec();
        for (Holder<T> value : result.elements()) {
            if (value.m_203376_() == Holder.Kind.DIRECT || !(value instanceof Holder.Reference)) {
                throw new IllegalStateException("Direct holder in world gen provider: " + value);
            }
            Holder.Reference ref = (Holder.Reference)value;
            if (!ref.m_203633_()) {
                throw new IllegalStateException("Unbound holder in world gen provider: " + value);
            }
            ResourceLocation id = ref.m_205785_().m_135782_();
            Path dest = result.getPath(this.generator.m_123916_().toAbsolutePath().normalize(), id);
            DataResult data = codec.encodeStart(ops, result.modify(id, ref.m_203334_()));
            if (data.result().isPresent()) {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)data.result().get()), (Path)dest);
                continue;
            }
            throw new IllegalStateException("Failed to encode element " + ref.m_205785_() + ": " + data.error().map(DataResult.PartialResult::message).orElse("unknown"));
        }
    }
}

