/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.api.event;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class SimpleHarvestEvent
extends Event {
    public final BlockState blockState;
    public final BlockPos pos;
    public final InteractionHand hand;
    public final Player player;
    public final Source type;
    private BlockPos newTarget;
    private ActionType action;

    public SimpleHarvestEvent(BlockState blockState, BlockPos pos, InteractionHand hand, Player player, boolean isHoe, ActionType actionType) {
        this.blockState = blockState;
        this.pos = pos;
        this.hand = hand;
        this.player = player;
        this.newTarget = pos;
        this.type = isHoe ? Source.HOE : Source.RIGHT_CLICK;
        this.action = actionType;
    }

    public void setTargetPos(BlockPos pos) {
        this.newTarget = pos;
    }

    public Source getInteractionSource() {
        return this.type;
    }

    public void setCanceled(boolean cancel) {
        if (cancel) {
            this.action = ActionType.NONE;
        }
        super.setCanceled(cancel);
    }

    public ActionType getAction() {
        return this.action;
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public BlockPos getTargetPos() {
        return this.newTarget;
    }

    public static enum Source {
        RIGHT_CLICK,
        HOE;

    }

    public static enum ActionType {
        NONE,
        CLICK,
        HARVEST;

    }
}

