/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.InventoryIIH;
import vazkii.quark.addons.oddities.module.BackpackModule;
import vazkii.quark.api.event.GatherToolClassesEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, antiOverlap={"inventorytweaks"})
public class AutomaticToolRestockModule
extends QuarkModule {
    private static final Map<ToolAction, String> ACTION_TO_CLASS = new HashMap<ToolAction, String>();
    private static final WeakHashMap<Player, Stack<QueuedRestock>> replacements;
    public List<Enchantment> importantEnchants = new ArrayList<Enchantment>();
    public List<Item> itemsToIgnore = new ArrayList<Item>();
    @Config(name="Important Enchantments", description="Enchantments deemed important enough to have special priority when finding a replacement")
    private List<String> enchantNames = AutomaticToolRestockModule.generateDefaultEnchantmentList();
    @Config(description="Enable replacing your tools with tools of the same type but not the same item")
    private boolean enableLooseMatching = true;
    @Config(description="Enable comparing enchantments to find a replacement")
    private boolean enableEnchantMatching = true;
    @Config(description="Allow pulling items from one hotbar slot to another")
    private boolean checkHotbar = false;
    @Config
    private boolean unstackablesOnly = false;
    @Config(description="Any items you place in this list will be ignored by the restock feature")
    private List<String> ignoredItems = Lists.newArrayList((Object[])new String[]{"botania:exchange_rod", "botania:dirt_rod", "botania:skydirt_rod", "botania:cobble_rod"});
    private Object mutex = new Object();

    @Override
    public void configChanged() {
        this.importantEnchants = MiscUtil.massRegistryGet(this.enchantNames, ForgeRegistries.ENCHANTMENTS);
        this.itemsToIgnore = MiscUtil.massRegistryGet(this.ignoredItems, ForgeRegistries.ITEMS);
    }

    @SubscribeEvent
    public void onToolBreak(PlayerDestroyItemEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getOriginal();
        Item item = stack.m_41720_();
        if (!(player == null || player.f_19853_ == null || player.f_19853_.f_46443_ || stack.m_41619_() || item instanceof ArmorItem || this.unstackablesOnly && stack.m_41753_())) {
            ItemStack backpack;
            int currSlot = player.m_150109_().f_35977_;
            if (event.getHand() == InteractionHand.OFF_HAND) {
                currSlot = player.m_150109_().m_6643_() - 1;
            }
            List<Enchantment> enchantmentsOnStack = this.getImportantEnchantments(stack);
            Predicate<ItemStack> itemPredicate = other -> other.m_41720_() == item;
            if (!stack.m_41763_()) {
                itemPredicate = itemPredicate.and(other -> other.m_41773_() == stack.m_41773_());
            }
            Predicate<ItemStack> enchantmentPredicate = other -> !new ArrayList(enchantmentsOnStack).retainAll(this.getImportantEnchantments((ItemStack)other));
            HashSet<String> classes = this.getItemClasses(stack);
            Optional<Predicate<ItemStack>> toolPredicate = Optional.empty();
            if (!classes.isEmpty()) {
                toolPredicate = Optional.of(other -> {
                    HashSet<String> otherClasses = this.getItemClasses((ItemStack)other);
                    return !otherClasses.isEmpty() && !otherClasses.retainAll(classes);
                });
            }
            RestockContext ctx = new RestockContext(player, currSlot, enchantmentsOnStack, itemPredicate, enchantmentPredicate, toolPredicate);
            int lower = this.checkHotbar ? 0 : 9;
            int upper = player.m_150109_().f_35974_.size();
            boolean foundInInv = this.crawlInventory((IItemHandler)new PlayerInvWrapper(player.m_150109_()), lower, upper, ctx);
            if (!foundInInv && ModuleLoader.INSTANCE.isModuleEnabled(BackpackModule.class) && (backpack = (ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_() == BackpackModule.backpack) {
                InventoryIIH inv = new InventoryIIH(backpack);
                this.crawlInventory((IItemHandler)inv, 0, inv.getSlots(), ctx);
            }
        }
    }

    private boolean crawlInventory(IItemHandler inv, int lowerBound, int upperBound, RestockContext ctx) {
        Player player = ctx.player;
        int currSlot = ctx.currSlot;
        List<Enchantment> enchantmentsOnStack = ctx.enchantmentsOnStack;
        Predicate<ItemStack> itemPredicate = ctx.itemPredicate;
        Predicate<ItemStack> enchantmentPredicate = ctx.enchantmentPredicate;
        Optional<Predicate<ItemStack>> toolPredicateOpt = ctx.toolPredicate;
        if (this.enableEnchantMatching && this.findReplacement(inv, player, lowerBound, upperBound, currSlot, itemPredicate.and(enchantmentPredicate))) {
            return true;
        }
        if (this.findReplacement(inv, player, lowerBound, upperBound, currSlot, itemPredicate)) {
            return true;
        }
        if (this.enableLooseMatching && toolPredicateOpt.isPresent()) {
            Predicate<ItemStack> toolPredicate = toolPredicateOpt.get();
            if (this.enableEnchantMatching && !enchantmentsOnStack.isEmpty() && this.findReplacement(inv, player, lowerBound, upperBound, currSlot, toolPredicate.and(enchantmentPredicate))) {
                return true;
            }
            return this.findReplacement(inv, player, lowerBound, upperBound, currSlot, toolPredicate);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_ && replacements.containsKey(event.player)) {
            Stack<QueuedRestock> replacementStack = replacements.get(event.player);
            Object object = this.mutex;
            synchronized (object) {
                while (!replacementStack.isEmpty()) {
                    QueuedRestock restock = replacementStack.pop();
                    this.switchItems(event.player, restock);
                }
            }
        }
    }

    private HashSet<String> getItemClasses(ItemStack stack) {
        Item item = stack.m_41720_();
        HashSet<String> classes = new HashSet<String>();
        if (item instanceof BowItem) {
            classes.add("bow");
        } else if (item instanceof CrossbowItem) {
            classes.add("crossbow");
        }
        for (ToolAction action : ACTION_TO_CLASS.keySet()) {
            if (!item.canPerformAction(stack, action)) continue;
            classes.add(ACTION_TO_CLASS.get(action));
        }
        GatherToolClassesEvent event = new GatherToolClassesEvent(stack, classes);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findReplacement(IItemHandler inv, Player player, int lowerBound, int upperBound, int currSlot, Predicate<ItemStack> match) {
        Object object = this.mutex;
        synchronized (object) {
            for (int i = lowerBound; i < upperBound; ++i) {
                ItemStack stackAt;
                if (i == currSlot || (stackAt = inv.getStackInSlot(i)).m_41619_() || !match.test(stackAt)) continue;
                this.pushReplace(player, inv, i, currSlot);
                return true;
            }
            return false;
        }
    }

    private void pushReplace(Player player, IItemHandler inv, int slot1, int slot2) {
        if (!replacements.containsKey(player)) {
            replacements.put(player, new Stack());
        }
        replacements.get(player).push(new QueuedRestock(inv, slot1, slot2));
    }

    private void switchItems(Player player, QueuedRestock restock) {
        Inventory playerInv = player.m_150109_();
        IItemHandler providingInv = restock.providingInv;
        int providingSlot = restock.providingSlot;
        int playerSlot = restock.playerSlot;
        if (providingSlot >= providingInv.getSlots() || playerSlot >= playerInv.f_35974_.size()) {
            return;
        }
        ItemStack stackAtPlayerSlot = playerInv.m_8020_(playerSlot).m_41777_();
        ItemStack stackProvidingSlot = providingInv.getStackInSlot(providingSlot).m_41777_();
        if (this.itemIgnored(stackAtPlayerSlot) || this.itemIgnored(stackProvidingSlot)) {
            return;
        }
        providingInv.extractItem(providingSlot, stackProvidingSlot.m_41613_(), false);
        providingInv.insertItem(providingSlot, stackAtPlayerSlot, false);
        playerInv.m_6836_(playerSlot, stackProvidingSlot);
    }

    private boolean itemIgnored(ItemStack stack) {
        return stack != null && !stack.m_150930_(Items.f_41852_) && this.itemsToIgnore.contains(stack.m_41720_());
    }

    private List<Enchantment> getImportantEnchantments(ItemStack stack) {
        ArrayList<Enchantment> enchantsOnStack = new ArrayList<Enchantment>();
        for (Enchantment ench : this.importantEnchants) {
            if (EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack) <= 0) continue;
            enchantsOnStack.add(ench);
        }
        return enchantsOnStack;
    }

    private static List<String> generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.f_44985_, Enchantments.f_44987_, Enchantments.f_44952_, Enchantments.f_44953_, Enchantments.f_44982_};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            strings.add(Registry.f_122825_.m_7981_((Object)e).toString());
        }
        return strings;
    }

    static {
        ACTION_TO_CLASS.put(ToolActions.AXE_DIG, "axe");
        ACTION_TO_CLASS.put(ToolActions.HOE_DIG, "hoe");
        ACTION_TO_CLASS.put(ToolActions.SHOVEL_DIG, "shovel");
        ACTION_TO_CLASS.put(ToolActions.PICKAXE_DIG, "pickaxe");
        ACTION_TO_CLASS.put(ToolActions.SWORD_SWEEP, "sword");
        ACTION_TO_CLASS.put(ToolActions.SHEARS_HARVEST, "shears");
        ACTION_TO_CLASS.put(ToolActions.FISHING_ROD_CAST, "fishing_rod");
        replacements = new WeakHashMap();
    }

    private record RestockContext(Player player, int currSlot, List<Enchantment> enchantmentsOnStack, Predicate<ItemStack> itemPredicate, Predicate<ItemStack> enchantmentPredicate, Optional<Predicate<ItemStack>> toolPredicate) {
    }

    private record QueuedRestock(IItemHandler providingInv, int providingSlot, int playerSlot) {
    }
}

