/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import owmii.powah.api.PowahAPI;

public class HeatSourceCategory
implements IRecipeCategory<Recipe> {
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"powah", (String)"heat_source", Recipe.class);
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    private final IDrawable background;
    private final IDrawable icon;

    public HeatSourceCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50450_));
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.powah.jei.category.heat.sources");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 4, 5);
        if (recipe.block() != null) {
            input.addItemStack(recipe.block());
        }
        if (recipe.fluid != null) {
            input.addFluidStack(recipe.fluid, FluidStack.bucketAmount());
        }
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, ChatFormatting.DARK_GRAY + I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + ChatFormatting.RESET + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{recipe.heat}), 30.0f, 9.0f, 12858368);
    }

    public static List<Recipe> getRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Item item : Registry.f_122827_) {
            BlockItem blockItem;
            Block block;
            ResourceLocation blockId;
            Integer heat;
            if (!(item instanceof BlockItem) || (heat = PowahAPI.HEAT_SOURCES.getOrDefault(blockId = Registry.f_122824_.m_7981_((Object)(block = (blockItem = (BlockItem)item).m_40614_())), 0)) == 0) continue;
            recipes.add(new Recipe(blockItem.m_7968_(), null, heat));
        }
        for (Map.Entry entry : Registry.f_122822_.m_6579_()) {
            ResourceLocation fluidId = ((ResourceKey)entry.getKey()).m_135782_();
            Integer heat = PowahAPI.HEAT_SOURCES.getOrDefault(fluidId, 0);
            if (heat == 0) continue;
            recipes.add(new Recipe(null, (Fluid)entry.getValue(), heat));
        }
        recipes.sort(Comparator.comparingInt(Recipe::heat));
        return recipes;
    }

    public record Recipe(@Nullable ItemStack block, @Nullable Fluid fluid, int heat) {
    }
}

