/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import owmii.powah.EnvHandler;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.item.Stacks;
import owmii.powah.lib.logistics.inventory.ItemHandlerHelper;
import owmii.powah.lib.logistics.inventory.ItemStackHandler;
import owmii.powah.lib.util.Util;

public class Inventory
extends ItemStackHandler {
    @Nullable
    private IInventoryHolder tile;
    private Object platformWrapper;
    private boolean sendUpdates = true;

    public Inventory(int size) {
        this(size, null);
    }

    public Inventory(Stacks stacks) {
        this(stacks, null);
    }

    public Inventory(Stacks stacks, @Nullable IInventoryHolder tile) {
        super(stacks);
        this.tile = tile;
    }

    Inventory(int size, @Nullable IInventoryHolder tile) {
        super(size);
        this.tile = tile;
    }

    public static <I extends AbstractTileEntity> Inventory create(int size, @Nullable I tile) {
        return new Inventory(size, (IInventoryHolder)((Object)tile));
    }

    public static <I extends AbstractTileEntity> Inventory createBlank(@Nullable I tile) {
        return new Inventory(0, (IInventoryHolder)((Object)tile));
    }

    public static Inventory create(int size) {
        return new Inventory(size, null);
    }

    public static Inventory createBlank() {
        return new Inventory(0, null);
    }

    public void setTile(@Nullable IInventoryHolder tile) {
        this.tile = tile;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (this.isBlank()) {
            return;
        }
        nbt.m_128405_("Size", this.getSlots());
        super.deserializeNBT(nbt);
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.isBlank() ? new CompoundTag() : super.serializeNBT();
    }

    public Inventory set(int size) {
        this.stacks = Stacks.withSize(size, ItemStack.f_41583_);
        this.onContentsChanged(0);
        return this;
    }

    public Inventory add(int size) {
        this.stacks = Stacks.withSize(size + this.stacks.size(), ItemStack.f_41583_);
        return this;
    }

    public Stacks canPut(Stacks outputs, int ... slots) {
        return this.canPut(outputs, this.fromSlotArray(slots));
    }

    public Stacks canPut(Stacks outputs, Stacks slots) {
        Inventory inv = new Inventory(Stacks.from(slots).copy());
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (ItemHandlerHelper.insertItem(inv, stack.m_41777_(), false).m_41619_()) continue;
            return Stacks.create();
        }
        return inv.getStacks();
    }

    public Stacks fromSlotArray(int ... slots) {
        Stacks stacks = Stacks.create();
        for (int i : slots) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.tile != null) {
            return this.tile.getSlotLimit(slot);
        }
        return super.getSlotLimit(slot);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canInsert(slot, stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.canExtract(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
    }

    public ItemStack extractItemFromSlot(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtract(int slot, ItemStack stack) {
        if (this.tile != null) {
            return this.tile.canExtract(slot, stack);
        }
        return true;
    }

    public void setSendUpdates(boolean sendUpdates) {
        this.sendUpdates = sendUpdates;
    }

    @Override
    public void onContentsChanged(int slot) {
        if (this.tile != null && this.sendUpdates) {
            this.tile.onSlotChanged(slot);
        }
    }

    public ItemStack getFirst() {
        return this.getStackInSlot(0);
    }

    public ItemStack getLast() {
        return this.getStackInSlot(this.getLastSlot());
    }

    public int getLastSlot() {
        return this.getSlots() - 1;
    }

    public Stacks getLast(int count) {
        Stacks stacks = Stacks.create();
        int size = this.stacks.size();
        for (int i = size - count; i < count; ++i) {
            stacks.add((ItemStack)this.stacks.get(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (ItemStack stack : this.stacks) {
            if (!stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotEmpty(int slot) {
        return ((ItemStack)this.stacks.get(slot)).m_41619_();
    }

    public ItemStack setSlotEmpty(int slot) {
        ItemStack stack = (ItemStack)this.stacks.set(slot, (Object)ItemStack.f_41583_);
        this.onContentsChanged(slot);
        return stack;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack stack1 = (ItemStack)this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void clear() {
        this.set(this.getSlots());
    }

    public boolean isBlank() {
        return this.stacks.size() <= 0;
    }

    public Stacks getStacks() {
        return Stacks.from((NonNullList<ItemStack>)this.stacks);
    }

    public List<ItemStack> getNonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        stacks.removeIf(ItemStack::m_41619_);
        return stacks;
    }

    public ItemStack addNext(ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            this.insertItem(i, stack.m_41777_(), false);
            return stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeNext() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = this.setSlotEmpty(i);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate, int ... ex) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (Util.anyMatch(ex, i) || !(stack = this.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public void drop(Level world, BlockPos pos) {
        this.stacks.forEach(stack -> Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
        this.clear();
    }

    public void drop(int index, Level world, BlockPos pos) {
        ItemStack stack = this.getStackInSlot(index);
        if (!stack.m_41619_()) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            this.setStackInSlot(index, ItemStack.f_41583_);
        }
    }

    public static int calcRedstone(ItemStackHandler inv) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(inv.getSlotLimit(j), itemstack.m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public Object getPlatformWrapper() {
        if (this.platformWrapper == null) {
            this.platformWrapper = EnvHandler.INSTANCE.createInvWrapper(this);
        }
        return this.platformWrapper;
    }
}

