/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EnchantmentUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.f_36078_ = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = EnchantmentUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float getPower(Level world, BlockPos position) {
        float power = 0.0f;
        for (int deltaZ = -1; deltaZ <= 1; ++deltaZ) {
            for (int deltaX = -1; deltaX <= 1; ++deltaX) {
                if (deltaZ == 0 && deltaX == 0 || !world.m_46859_(position.m_7918_(deltaX, 0, deltaZ)) || !world.m_46859_(position.m_7918_(deltaX, 1, deltaZ))) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 1, deltaZ * 2));
                if (deltaX == 0 || deltaZ == 0) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 0, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX * 2, 1, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.m_7918_(deltaX, 1, deltaZ * 2));
            }
        }
        return power;
    }

    static float getEnchantPower(Level world, BlockPos pos) {
        return world.m_8055_(pos).getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            items.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
        }
    }
}

