/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import potionstudios.byg.common.world.structure.AncientTreePiece;
import potionstudios.byg.common.world.structure.BYGStructureTypes;

public class AncientSequoiaTreeStructure
extends Structure {
    public static final Codec<AncientSequoiaTreeStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)AncientSequoiaTreeStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)Config.CODEC.fieldOf("config").forGetter(ancientSequoiaTreeStructure -> ancientSequoiaTreeStructure.config)).apply((Applicative)builder, AncientSequoiaTreeStructure::new)).codec();
    private final Config config;

    protected AncientSequoiaTreeStructure(Structure.StructureSettings structureSettings, Config config) {
        super(structureSettings);
        this.config = config;
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context, Config config) {
        Optional structureTemplateOptional = context.f_226625_().m_230407_(config.location);
        if (structureTemplateOptional.isEmpty()) {
            throw new IllegalArgumentException("Invalid structure template id \"%s\"".formatted(config.location));
        }
        WorldgenRandom random = context.f_226626_();
        ChunkPos chunkPos = context.f_226628_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        int blockY = context.f_226622_().m_223221_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()) + 1;
        piecesBuilder.m_142679_((StructurePiece)new AncientTreePiece((StructureTemplate)structureTemplateOptional.get(), config.location, new BlockPos(blockX, blockY, blockZ), AncientSequoiaTreeStructure.getWritableArea(chunkPos, context.f_226629_())));
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int k = accessor.m_141937_() + 1;
        int l = accessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        return AncientSequoiaTreeStructure.m_226585_((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> AncientSequoiaTreeStructure.generatePieces(piecesBuilder, generationContext, this.config));
    }

    public StructureType<?> m_213658_() {
        return BYGStructureTypes.ANCIENT_SEQUOIA_TREE.get();
    }

    public record Config(ResourceLocation location, boolean stripsAir) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("location").forGetter(config -> config.location), (App)Codec.BOOL.fieldOf("no_air").forGetter(config -> config.stripsAir)).apply((Applicative)builder, Config::new));
    }
}

