/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.preset;

import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import potionstudios.byg.common.world.biome.BYGBiomeTags;
import potionstudios.byg.common.world.biome.BYGDebugBiomeSource;
import potionstudios.byg.reg.RegistrationProvider;
import potionstudios.byg.reg.RegistryObject;

public class BYGWorldPresets {
    public static final RegistrationProvider<WorldPreset> PROVIDER = RegistrationProvider.get(BuiltinRegistries.f_235989_, "byg");
    public static final RegistryObject<WorldPreset> DEBUG_BIOMES = BYGWorldPresets.register("debug_biomes", () -> {
        Registry dimensionTypes = BuiltinRegistries.f_235987_;
        Registry biomes = BuiltinRegistries.f_123865_;
        Registry structureSets = BuiltinRegistries.f_211084_;
        Registry noiseSettings = BuiltinRegistries.f_123866_;
        Registry noises = BuiltinRegistries.f_194654_;
        IdMap holders = biomes.m_206115_();
        Holder overworldNoiseGenSettings = noiseSettings.m_214121_(NoiseGeneratorSettings.f_64432_);
        Holder overworldDimensionType = dimensionTypes.m_214121_(BuiltinDimensionTypes.f_223538_);
        LevelStem overworldStem = new LevelStem(overworldDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)new BYGDebugBiomeSource(StreamSupport.stream(holders.spliterator(), false), BYGBiomeTags.IS_OVERWORLD), overworldNoiseGenSettings));
        Holder netherDimensionType = dimensionTypes.m_214121_(BuiltinDimensionTypes.f_223539_);
        Holder netherNoiseSettings = noiseSettings.m_214121_(NoiseGeneratorSettings.f_64434_);
        LevelStem netherStem = new LevelStem(netherDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)new BYGDebugBiomeSource(StreamSupport.stream(holders.spliterator(), false), BYGBiomeTags.IS_NETHER), netherNoiseSettings));
        Holder endDimensionType = dimensionTypes.m_214121_(BuiltinDimensionTypes.f_223540_);
        Holder endNoiseSettings = noiseSettings.m_214121_(NoiseGeneratorSettings.f_64435_);
        LevelStem endStem = new LevelStem(endDimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)new BYGDebugBiomeSource(StreamSupport.stream(holders.spliterator(), false), BYGBiomeTags.IS_END), endNoiseSettings));
        Map<ResourceKey, LevelStem> stemMap = Map.of(LevelStem.f_63971_, overworldStem, LevelStem.f_63972_, netherStem, LevelStem.f_63973_, endStem);
        return new WorldPreset(stemMap);
    });

    private static RegistryObject<WorldPreset> register(String id, Supplier<WorldPreset> value) {
        return PROVIDER.register(id, value);
    }

    public static void loadClass() {
    }
}

