/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import potionstudios.byg.common.block.BYGBlocks;

public class GiantFlowerConfig
implements FeatureConfiguration {
    public static final Codec<GiantFlowerConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)BlockStateProvider.f_68747_.fieldOf("petal_provider").forGetter(config -> config.petalProvider), (App)BlockStateProvider.f_68747_.fieldOf("petal2_provider").forGetter(config -> config.petalProvider), (App)BlockStateProvider.f_68747_.fieldOf("petal3_provider").forGetter(config -> config.petalProvider), (App)BlockStateProvider.f_68747_.fieldOf("pollen_provider").forGetter(config -> config.pollenProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)1).forGetter(config -> config.maxPossibleHeight)).apply((Applicative)codecRecorder, GiantFlowerConfig::new));
    private final BlockStateProvider stemProvider;
    private final BlockStateProvider petalProvider;
    private final BlockStateProvider petal2Provider;
    private final BlockStateProvider petal3Provider;
    private final BlockStateProvider pollenProvider;
    private final int minHeight;
    private final int maxPossibleHeight;
    private boolean forcedPlacement = false;

    GiantFlowerConfig(BlockStateProvider stemProvider, BlockStateProvider petalProvider, BlockStateProvider petal2Provider, BlockStateProvider petal3Provider, BlockStateProvider pollenProvider, int minHeight, int maxPossibleHeight) {
        this.stemProvider = stemProvider;
        this.petalProvider = petalProvider;
        this.petal2Provider = petal2Provider;
        this.petal3Provider = petal3Provider;
        this.pollenProvider = pollenProvider;
        this.minHeight = minHeight;
        this.maxPossibleHeight = maxPossibleHeight;
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public BlockStateProvider getStemProvider() {
        return this.stemProvider;
    }

    public BlockStateProvider getPetalProvider() {
        return this.petalProvider;
    }

    public BlockStateProvider getPetal2Provider() {
        return this.petal2Provider;
    }

    public BlockStateProvider getPetal3Provider() {
        return this.petal3Provider;
    }

    public BlockStateProvider getPollenProvider() {
        return this.pollenProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxPossibleHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private BlockStateProvider stemProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider petalProvider;
        private BlockStateProvider petal2Provider = this.petalProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        private BlockStateProvider petal3Provider = this.petalProvider;
        private BlockStateProvider pollenProvider = SimpleStateProvider.m_191384_((BlockState)BYGBlocks.POLLEN_BLOCK.defaultBlockState());
        private int minHeight = 15;
        private int maxPossibleHeight = 1;

        public Builder setStemBlock(Block block) {
            this.stemProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setStemBlock(BlockState state) {
            this.stemProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setPetalBlock(Block block) {
            this.petalProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setPetalBlock(BlockState state) {
            this.petalProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setPetalBlock(WeightedStateProvider statesList) {
            this.petalProvider = statesList != null ? statesList : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setPetal2Block(Block block) {
            this.petal2Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.petalProvider;
            return this;
        }

        public Builder setPetal2Block(BlockState state) {
            this.petal2Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.petalProvider;
            return this;
        }

        public Builder setPetal3Block(Block block) {
            this.petal3Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.petalProvider;
            return this;
        }

        public Builder setPetal3Block(BlockState state) {
            this.petal3Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.petalProvider;
            return this;
        }

        public Builder setPollenBlock(Block block) {
            this.petal3Provider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : this.petalProvider;
            return this;
        }

        public Builder setPollenBlock(BlockState state) {
            this.petal3Provider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : this.petalProvider;
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder copy(GiantFlowerConfig config) {
            this.maxPossibleHeight = config.maxPossibleHeight;
            this.minHeight = config.minHeight;
            this.stemProvider = config.stemProvider;
            this.petalProvider = config.petalProvider;
            this.petal2Provider = config.petal2Provider;
            this.petal3Provider = config.petal3Provider;
            this.pollenProvider = config.pollenProvider;
            return this;
        }

        public GiantFlowerConfig build() {
            return new GiantFlowerConfig(this.stemProvider, this.petalProvider, this.petal2Provider, this.petal3Provider, this.pollenProvider, this.minHeight, this.maxPossibleHeight);
        }
    }
}

