/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.boat;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.common.block.BYGWoodTypes;
import potionstudios.byg.common.entity.BYGEntities;
import potionstudios.byg.common.entity.boat.BYGChestBoat;
import potionstudios.byg.common.loot.BYGLootContextParams;
import potionstudios.byg.mixin.access.BoatEntityAccess;

public class BYGBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BYG_BOAT_TYPE = SynchedEntityData.m_135353_(BYGBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final LootContextParamSet LOOT_CONTEXT_PARAM_SETS = LootContextParamSet.m_165477_().m_81406_(BYGLootContextParams.BOAT_TYPE).m_81406_(LootContextParams.f_81455_).m_81406_(LootContextParams.f_81460_).m_81406_(LootContextParams.f_81457_).m_81405_();

    public BYGBoat(Level worldIn, double x, double y, double z) {
        this(BYGEntities.BOAT.get(), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public BYGBoat(EntityType<? extends Boat> boatEntityType, Level worldType) {
        super(boatEntityType, worldType);
    }

    public static ResourceLocation getLootLocation(BYGType type, boolean isChest, boolean isFall) {
        ResourceLocation regName = BYGEntities.BOAT.getId();
        String typeName = type + (isChest ? "_chest" : "");
        return isFall ? new ResourceLocation(regName.m_135827_(), "boats/" + typeName + "_fall") : new ResourceLocation(regName.m_135827_(), "boats/" + typeName);
    }

    public List<ItemStack> getDrops(DamageSource damageSource, boolean isFall) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootContext lootContext = new LootContext.Builder(serverLevel).m_78972_(BYGLootContextParams.BOAT_TYPE, (Object)this.getBYGBoatType()).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78975_(LOOT_CONTEXT_PARAM_SETS);
            ResourceLocation regName = Registry.f_122826_.m_7981_((Object)this.m_6095_());
            ResourceLocation defaultLocation = this.m_6095_().m_20677_();
            LootTable any = serverLevel.m_7654_().m_129898_().m_79217_(isFall ? new ResourceLocation(defaultLocation.m_135827_(), defaultLocation.m_135815_() + "_fall") : defaultLocation);
            if (any != LootTable.f_79105_) {
                return any.m_230922_(lootContext);
            }
            LootTable lootTable = serverLevel.m_7654_().m_129898_().m_79217_(BYGBoat.getLootLocation(this.getBYGBoatType(), this instanceof BYGChestBoat, isFall));
            return lootTable.m_230922_(lootContext);
        }
        return List.of();
    }

    @NotNull
    public Item m_38369_() {
        BYGWoodTypes type = BYGWoodTypes.LOOKUP.get(this.getBYGBoatType().getName());
        if (type != null) {
            return type.boat().get();
        }
        return BYGWoodTypes.ASPEN.boat().get();
    }

    public Block getPlanks() {
        BYGWoodTypes type = BYGWoodTypes.LOOKUP.get(this.getBYGBoatType().getName());
        if (type != null) {
            return (Block)type.planks().get();
        }
        return (Block)BYGWoodTypes.ASPEN.planks().get();
    }

    public BYGType getBYGBoatType() {
        return BYGType.byId((Integer)this.f_19804_.m_135370_(BYG_BOAT_TYPE));
    }

    public void setBYGBoatType(BYGType boatBYGType) {
        this.f_19804_.m_135381_(BYG_BOAT_TYPE, (Object)boatBYGType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BYG_BOAT_TYPE, (Object)BYGType.ASPEN.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("BYGType", this.getBYGBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BYGType", 8)) {
            this.setBYGBoatType(BYGType.getTypeFromString(compound.m_128461_("BYGType")));
        }
    }

    public void m_6053_() {
        this.m_38362_(-this.m_38386_());
        this.m_38354_(10);
        this.m_38311_(this.m_38384_() * 11.0f);
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
        ((BoatEntityAccess)((Object)this)).byg_setLastYd(this.m_20184_().f_82480_);
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (((BoatEntityAccess)((Object)this)).byg_getStatusField() != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.getDrops(DamageSource.f_19315_, true).forEach(arg_0 -> ((BYGBoat)this).m_19983_(arg_0));
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        block6: {
            if (this.m_6673_(source)) {
                return false;
            }
            if (this.f_19853_.f_46443_ || this.m_213877_()) break block6;
            if (source instanceof IndirectEntityDamageSource && source.m_7639_() != null && this.m_20363_(source.m_7639_())) {
                return false;
            }
            this.m_38362_(-this.m_38386_());
            this.m_38354_(10);
            this.m_38311_(this.m_38384_() + amount * 10.0f);
            this.m_5834_();
            var5_3 = source.m_7639_();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.m_38384_() > 40.0f) {
                if (!flag && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.getDrops(source, false).forEach((Consumer<ItemStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, m_19983_(net.minecraft.world.item.ItemStack ), (Lnet/minecraft/world/item/ItemStack;)V)((BYGBoat)this));
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static enum BYGType {
        ASPEN("aspen", () -> BYGWoodTypes.ASPEN.chestBoat().get()),
        BAOBAB("baobab", () -> BYGWoodTypes.BAOBAB.chestBoat().get()),
        BLUE_ENCHANTED("blue_enchanted", () -> BYGWoodTypes.BLUE_ENCHANTED.chestBoat().get()),
        CHERRY("cherry", () -> BYGWoodTypes.CHERRY.chestBoat().get()),
        CIKA("cika", () -> BYGWoodTypes.CIKA.chestBoat().get()),
        CYPRESS("cypress", () -> BYGWoodTypes.CYPRESS.chestBoat().get()),
        EBONY("ebony", () -> BYGWoodTypes.EBONY.chestBoat().get()),
        FIR("fir", () -> BYGWoodTypes.FIR.chestBoat().get()),
        GREEN_ENCHANTED("green_enchanted", () -> BYGWoodTypes.GREEN_ENCHANTED.chestBoat().get()),
        HOLLY("holly", () -> BYGWoodTypes.HOLLY.chestBoat().get()),
        JACARANDA("jacaranda", () -> BYGWoodTypes.JACARANDA.chestBoat().get()),
        MAHOGANY("mahogany", () -> BYGWoodTypes.MAHOGANY.chestBoat().get()),
        MANGROVE("white_mangrove", () -> BYGWoodTypes.WHITE_MANGROVE.chestBoat().get()),
        MAPLE("maple", () -> BYGWoodTypes.MAPLE.chestBoat().get()),
        PALM("palm", () -> BYGWoodTypes.PALM.chestBoat().get()),
        PINE("pine", () -> BYGWoodTypes.PINE.chestBoat().get()),
        RAINBOW_EUCALYPTUS("rainbow_eucalyptus", () -> BYGWoodTypes.RAINBOW_EUCALYPTUS.chestBoat().get()),
        REDWOOD("redwood", () -> BYGWoodTypes.REDWOOD.chestBoat().get()),
        SKYRIS("skyris", () -> BYGWoodTypes.SKYRIS.chestBoat().get()),
        WILLOW("willow", () -> BYGWoodTypes.WILLOW.chestBoat().get()),
        WITCH_HAZEL("witch_hazel", () -> BYGWoodTypes.WITCH_HAZEL.chestBoat().get()),
        ZELKOVA("zelkova", () -> BYGWoodTypes.ZELKOVA.chestBoat().get());

        private final String name;
        private final Supplier<Item> chestBoatItem;

        private BYGType(String string2, Supplier<Item> chestBoatItem) {
            this.name = string2;
            this.chestBoatItem = chestBoatItem;
        }

        public Supplier<Item> chestBoatItem() {
            return this.chestBoatItem;
        }

        public static BYGType byId(int id) {
            BYGType[] aBYGBoatEntity$BYGType = BYGType.values();
            if (id < 0 || id >= aBYGBoatEntity$BYGType.length) {
                id = 0;
            }
            return aBYGBoatEntity$BYGType[id];
        }

        public static BYGType getTypeFromString(String nameIn) {
            BYGType[] aBYGBoatEntity$BYGType;
            for (BYGType BYGType2 : aBYGBoatEntity$BYGType = BYGType.values()) {
                if (!BYGType2.getName().equals(nameIn)) continue;
                return BYGType2;
            }
            return aBYGBoatEntity$BYGType[0];
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

