/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class PumpkinConfig
implements FeatureConfiguration {
    public static final Codec<PumpkinConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("pumpkin_provider").forGetter(config -> config.pumpkinProvider), (App)BlockStateProvider.f_68747_.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)BlockStateProvider.f_68747_.fieldOf("leaves_provider").forGetter(config -> config.leavesProvider)).apply((Applicative)codecRecorder, PumpkinConfig::new));
    private final BlockStateProvider pumpkinProvider;
    private final BlockStateProvider stemProvider;
    private final BlockStateProvider leavesProvider;

    PumpkinConfig(BlockStateProvider pumpkinProvider, BlockStateProvider stemProvider, BlockStateProvider leavesProvider) {
        this.pumpkinProvider = pumpkinProvider;
        this.stemProvider = stemProvider;
        this.leavesProvider = leavesProvider;
    }

    public BlockStateProvider getPumpkinProvider() {
        return this.pumpkinProvider;
    }

    public BlockStateProvider getStemProvider() {
        return this.stemProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    public static class Builder {
        private BlockStateProvider pumpkinProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50133_.m_49966_());
        private BlockStateProvider stemProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider leavesProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());

        public Builder setPumpkinBlock(Block block) {
            this.pumpkinProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setPumpkinBlock(BlockState state) {
            this.pumpkinProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public Builder setStemBlock(Block block) {
            this.stemProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setStemBlock(BlockState state) {
            this.stemProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = SimpleStateProvider.m_191384_((BlockState)block.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = SimpleStateProvider.m_191384_((BlockState)state);
            return this;
        }

        public PumpkinConfig build() {
            return new PumpkinConfig(this.pumpkinProvider, this.stemProvider, this.leavesProvider);
        }
    }
}

