/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;

public class BYGDebugBiomeSource
extends BiomeSource {
    private static final int WIDTH = Integer.parseInt(System.getProperty("byg.debug.biomes.width", "50"));
    public static final Codec<BYGDebugBiomeSource> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(bygEndBiomeSource -> null), (App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).fieldOf("filter").forGetter(bygDebugBiomeSource -> bygDebugBiomeSource.biomeTagKey)).apply((Applicative)builder, builder.stable(BYGDebugBiomeSource::new)));
    @Nullable
    private List<Holder<Biome>> possibleBiomesSorted;
    private final TagKey<Biome> biomeTagKey;

    public BYGDebugBiomeSource(Registry<Biome> biomeRegistry, TagKey<Biome> biomeTagKey) {
        super(StreamSupport.stream(biomeRegistry.m_206115_().spliterator(), false));
        this.biomeTagKey = biomeTagKey;
    }

    public BYGDebugBiomeSource(Stream<Holder<Biome>> holderStream, TagKey<Biome> biomeTagKey) {
        super(holderStream);
        this.possibleBiomesSorted = null;
        this.biomeTagKey = biomeTagKey;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        if (this.possibleBiomesSorted == null) {
            this.possibleBiomesSorted = this.m_207840_().stream().filter(biomeHolder -> biomeHolder.m_203656_(this.biomeTagKey)).sorted(Comparator.comparing(biomeHolder -> ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_())).toList();
        }
        return this.possibleBiomesSorted.get(Math.floorMod(z / WIDTH, this.possibleBiomesSorted.size()));
    }
}

