/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mythicbotany.MythicBotany;
import mythicbotany.jei.InfusionCategory;
import mythicbotany.jei.LittleBoxItemRenderer;
import mythicbotany.jei.RuneRitualCategory;
import mythicbotany.register.ModBlocks;
import mythicbotany.register.ModRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class MythicJei
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return MythicBotany.getInstance().resource("jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(registration.getJeiHelpers().getGuiHelper()), new RuneRitualCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipes = Objects.requireNonNull(level).m_7465_();
        registration.addRecipes(InfusionCategory.TYPE, recipes.m_44013_(ModRecipes.infuser));
        registration.addRecipes(RuneRitualCategory.TYPE, recipes.m_44013_(ModRecipes.runeRitual));
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.manaInfuser), new RecipeType[]{InfusionCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.centralRuneHolder), new RecipeType[]{RuneRitualCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.runeHolder), new RecipeType[]{RuneRitualCategory.TYPE});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime runtime) {
        LittleBoxItemRenderer.setParent((IIngredientRenderer<ItemStack>)runtime.getIngredientManager().getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK));
    }
}

