/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Triple;

public class LittleBoxItemRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Map<Triple<Integer, Integer, Boolean>, LittleBoxItemRenderer> renders = new HashMap<Triple<Integer, Integer, Boolean>, LittleBoxItemRenderer>();
    private static IIngredientRenderer<ItemStack> parent;
    private final int x;
    private final int z;
    private final boolean consume;

    public static LittleBoxItemRenderer getRenderer(int x, int z, boolean consume) {
        Triple triple = Triple.of((Object)x, (Object)z, (Object)consume);
        if (!renders.containsKey(triple)) {
            renders.put((Triple<Integer, Integer, Boolean>)triple, new LittleBoxItemRenderer(x, z, consume));
        }
        return renders.get(triple);
    }

    public static void setParent(IIngredientRenderer<ItemStack> parent) {
        LittleBoxItemRenderer.parent = parent;
    }

    private LittleBoxItemRenderer(int x, int z, boolean consume) {
        this.x = x;
        this.z = z;
        this.consume = x == 0 && z == 0 || consume;
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 12;
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull ItemStack stack) {
        if (parent != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(-2.0, -2.0, 0.0);
            parent.render(poseStack, (Object)stack);
            poseStack.m_85849_();
        }
    }

    @Nonnull
    public List<Component> getTooltip(@Nonnull ItemStack stack, @Nonnull TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (parent != null) {
            tooltip.addAll(parent.getTooltip((Object)stack, flag));
        }
        if (this.x != 0 || this.z != 0) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.mythicbotany.rune_offset", (Object[])new Object[]{this.x, this.z}).m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.mythicbotany.rune_central").m_130940_(ChatFormatting.GOLD));
        }
        if (this.consume) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.mythicbotany.rune_consume").m_130940_(ChatFormatting.DARK_RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.mythicbotany.rune_keep").m_130940_(ChatFormatting.DARK_GREEN));
        }
        return tooltip;
    }

    @Nonnull
    public Font getFontRenderer(@Nonnull Minecraft mc, @Nonnull ItemStack stack) {
        if (parent != null) {
            return parent.getFontRenderer(mc, (Object)stack);
        }
        return Minecraft.m_91087_().f_91062_;
    }
}

