/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.content;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import mythicbotany.alfheim.worldgen.AlfheimWorldGen;
import mythicbotany.register.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.SparkleParticleData;

public class AlfPixie
extends PathfinderMob {
    public AlfPixie(@Nonnull Level level) {
        this(ModEntities.alfPixie, level);
    }

    public AlfPixie(EntityType<AlfPixie> type, Level level) {
        super(type, level);
        this.f_21364_ = 3;
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, 0, true, false, entity -> true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, 0, true, false, entity -> true));
        this.initExtraAI();
    }

    protected void initExtraAI() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    public int m_5792_() {
        return 7;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.f_19797_ % 10 == 0 && this.f_20919_ == 0) {
            this.m_5634_(1.0f);
        }
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 4; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle((float)(0.1f + (float)Math.random() * 0.25f), (float)1.0f, (float)0.25f, (float)0.9f, (int)12);
                this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_() + (Math.random() - 0.5) * 0.25, this.m_20186_() + 0.5 + (Math.random() - 0.5) * 0.25, this.m_20189_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_6147_() {
        return false;
    }

    public void m_7023_(@Nonnull Vec3 travelVector) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            float groundModifier = 8.4044285f;
            this.m_19920_(this.f_19861_ ? 0.1f * groundModifier : 0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
        }
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public static AttributeSupplier entityAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 32.0).m_22265_();
    }

    public static boolean canSpawnAt(EntityType<AlfPixie> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos).m_60795_();
    }

    private static class MoveHelperController
    extends MoveControl {
        private final AlfPixie entity;
        private int cooldown;

        public MoveHelperController(AlfPixie entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.cooldown-- <= 0) {
                this.cooldown += this.entity.m_217043_().m_188503_(5) + 2;
                Vec3 motion = new Vec3(this.f_24975_ - this.entity.m_20185_(), this.f_24976_ - this.entity.m_20186_(), this.f_24977_ - this.entity.m_20189_());
                double d0 = motion.m_82553_();
                if (this.checkNoCollision(motion = motion.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(motion.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean checkNoCollision(Vec3 p_220673_1_, int p_220673_2_) {
            AABB aabb = this.entity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.entity.f_19853_.m_45756_((Entity)this.entity, aabb = aabb.m_82383_(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final AlfPixie entity;

        public RandomFlyGoal(AlfPixie entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double zd;
            double yd;
            MoveControl controller = this.entity.m_21566_();
            if (!controller.m_24995_()) {
                return true;
            }
            double xd = controller.m_25000_() - this.entity.m_20185_();
            double m = xd * xd + (yd = controller.m_25001_() - this.entity.m_20186_()) * yd + (zd = controller.m_25002_() - this.entity.m_20189_()) * zd;
            return m < 1.0 || m > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            int aboveGround = 0;
            BlockPos.MutableBlockPos mpos = this.entity.m_20183_().m_7495_().m_122032_();
            while (mpos.m_123342_() > 0 && AlfheimWorldGen.passthrough(this.entity.f_19853_.m_8055_((BlockPos)mpos))) {
                mpos.m_122173_(Direction.DOWN);
                if (++aboveGround < 10) continue;
            }
            RandomSource random = this.entity.m_217043_();
            double x = this.entity.m_20185_() + (random.m_188500_() * 2.0 - 1.0) * 16.0;
            double y = this.entity.m_20186_() + (random.m_188500_() * 2.0 - 1.0) * 16.0 - (double)(2 * (aboveGround - 5));
            double z = this.entity.m_20189_() + (random.m_188500_() * 2.0 - 1.0) * 16.0;
            this.entity.m_21566_().m_6849_(x, y, z, 0.8);
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final AlfPixie entity;

        public LookAroundGoal(AlfPixie entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.entity.m_5448_() == null) {
                Vec3 motion = this.entity.m_20184_();
                this.entity.m_146922_(-((float)Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_)) * 57.29578f);
                this.entity.f_20883_ = this.entity.m_146908_();
            } else {
                LivingEntity target = this.entity.m_5448_();
                if (target.m_20280_((Entity)this.entity) < 4096.0) {
                    double xd = target.m_20185_() - this.entity.m_20185_();
                    double zd = target.m_20189_() - this.entity.m_20189_();
                    this.entity.m_146922_(-((float)Mth.m_14136_((double)xd, (double)zd)) * 57.29578f);
                    this.entity.f_20883_ = this.entity.m_146908_();
                }
            }
        }
    }
}

