/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany;

import javax.annotation.Nonnull;
import mythicbotany.EventListener;
import mythicbotany.RecipeRemover;
import mythicbotany.advancement.ModCriteria;
import mythicbotany.alfheim.teleporter.AlfheimPortalHandler;
import mythicbotany.alfheim.worldgen.placement.AlfheimGroundModifier;
import mythicbotany.config.ClientConfig;
import mythicbotany.kvasir.WanderingTraderRuneInput;
import mythicbotany.loot.AlfsteelDisposeModifier;
import mythicbotany.loot.FimbultyrModifier;
import mythicbotany.mjoellnir.MjoellnirRuneOutput;
import mythicbotany.network.MythicNetwork;
import mythicbotany.patchouli.PageRitualInfo;
import mythicbotany.patchouli.PageRitualPattern;
import mythicbotany.pylon.PylonRepairables;
import mythicbotany.register.ModEnchantments;
import mythicbotany.register.ModEntities;
import mythicbotany.register.ModItems;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.util.density.DensityClamp;
import mythicbotany.util.density.DensityDebug;
import mythicbotany.util.density.DensityLerp;
import mythicbotany.util.density.DensitySmash;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.mod.ModXRegistration;
import org.moddingx.libx.registration.RegistrationBuilder;
import org.moddingx.libx.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.SlotTypePreset;
import vazkii.patchouli.client.book.ClientBookRegistry;

@Mod(value="mythicbotany")
public final class MythicBotany
extends ModXRegistration {
    public static final Logger logger = LoggerFactory.getLogger((String)"mythicbotany");
    private static MythicBotany instance;
    private static MythicNetwork network;

    public MythicBotany() {
        super(new CreativeModeTab("mythicbotany"){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModItems.alfsteelSword);
            }
        });
        instance = this;
        network = new MythicNetwork((ModX)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerMisc);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::createAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntities::createSpawnPlacement);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::datapacksReloaded);
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, AlfheimPortalHandler::renderGameOverlay));
        MinecraftForge.EVENT_BUS.addListener(AlfheimPortalHandler::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(AlfheimPortalHandler::endTick);
        Class extra = ClassUtil.forName((String)"mythicbotany.MythicBotanyExtra");
        if (extra != null) {
            try {
                extra.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nonnull
    public static MythicBotany getInstance() {
        return instance;
    }

    @Nonnull
    public static MythicNetwork getNetwork() {
        return network;
    }

    protected void initRegistration(RegistrationBuilder builder) {
    }

    private void registerMisc(RegisterEvent event) {
        event.register(Registry.f_211075_, this.resource("smash"), () -> DensitySmash.CODEC.f_216232_());
        event.register(Registry.f_211075_, this.resource("debug"), () -> DensityDebug.CODEC.f_216232_());
        event.register(Registry.f_211075_, this.resource("lerp"), () -> DensityLerp.CODEC.f_216232_());
        event.register(Registry.f_211075_, this.resource("clamp"), () -> DensityClamp.CODEC.f_216232_());
        event.register(Registry.f_194569_, this.resource("alfheim_ground"), () -> AlfheimGroundModifier.TYPE);
        event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, this.resource("dispose"), () -> AlfsteelDisposeModifier.CODEC);
        event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, this.resource("fimbultyr"), () -> FimbultyrModifier.CODEC);
    }

    protected void setup(FMLCommonSetupEvent event) {
        logger.info("Loading MythicBotany");
        event.enqueueWork(() -> {
            ModCriteria.setup();
            PylonRepairables.register(new PylonRepairables.ItemPylonRepairable(), 10);
            PylonRepairables.register(new PylonRepairables.MendingPylonRepairable(), -10);
            RuneRitualRecipe.registerSpecialInput(WanderingTraderRuneInput.INSTANCE);
            RuneRitualRecipe.registerSpecialOutput(MjoellnirRuneOutput.INSTANCE);
        });
    }

    protected void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ModEntities.clientSetup();
            ClientBookRegistry.INSTANCE.pageTypes.put(new ResourceLocation(this.modid, "ritual_pattern"), PageRitualPattern.class);
            ClientBookRegistry.INSTANCE.pageTypes.put(new ResourceLocation(this.modid, "ritual_info"), PageRitualInfo.class);
        });
    }

    private void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(3).build());
        InterModComms.sendTo((String)"apotheosis", (String)"set_ench_hard_cap", () -> new EnchantmentInstance(ModEnchantments.hammerMobility, 5));
    }

    public void serverStart(ServerStartingEvent event) {
        RecipeRemover.removeRecipes(event.getServer().m_129894_());
    }

    public void datapacksReloaded(OnDatapackSyncEvent event) {
        RecipeRemover.removeRecipes(event.getPlayerList().m_7873_().m_129894_());
    }
}

