/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class MobSoulHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        block3: {
            Player player;
            ItemStack held;
            Item item;
            Entity source = event.getSource().m_7639_();
            if (!(source instanceof Player) || !((item = (held = (player = (Player)source).m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof ISoulSiphoningItem)) break block3;
            ISoulSiphoningItem siphoner = (ISoulSiphoningItem)item;
            LivingEntity entity = event.getEntity();
            MobSoulType type = MobSoulTypeRegistry.getInstance().getMobSoulTypeByEntity(entity);
            if (type == null || !type.isEnabled()) {
                return;
            }
            List<ItemStack> jars = MobSoulHandler.getValidSoulJars(player, type);
            if (!jars.isEmpty()) {
                ItemStack jar;
                double remaining = siphoner.getSiphonAmount(held, entity);
                Iterator<ItemStack> iterator = jars.iterator();
                while (iterator.hasNext() && !((remaining = MobSoulUtils.addSoulsToJar(jar = iterator.next(), type, remaining)) <= 0.0)) {
                }
            }
        }
    }

    private static List<ItemStack> getValidSoulJars(Player player, MobSoulType type) {
        return player.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() instanceof SoulJarItem).filter(s -> MobSoulUtils.canAddTypeToJar(s, type)).sorted((a, b) -> MobSoulUtils.getType(a) != null ? -1 : (MobSoulUtils.getType(b) != null ? 0 : 1)).collect(Collectors.toList());
    }
}

