/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.integration.gender.GenderCapabilityHelper;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public class ItemHazmatSuitArmor
extends ArmorItem {
    private static final HazmatMaterial HAZMAT_MATERIAL = new HazmatMaterial();

    public ItemHazmatSuitArmor(EquipmentSlot slot, Item.Properties properties) {
        super((ArmorMaterial)HAZMAT_MATERIAL, slot, properties.m_41497_(Rarity.UNCOMMON));
    }

    public static double getShieldingByArmor(EquipmentSlot type) {
        return switch (type) {
            case EquipmentSlot.HEAD -> 0.25;
            case EquipmentSlot.CHEST -> 0.4;
            case EquipmentSlot.LEGS -> 0.2;
            case EquipmentSlot.FEET -> 0.15;
            default -> 0.0;
        };
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        ItemCapabilityWrapper wrapper = new ItemCapabilityWrapper(stack, RadiationShieldingHandler.create(item -> ItemHazmatSuitArmor.getShieldingByArmor(this.f_40377_)));
        GenderCapabilityHelper.addGenderCapability(this, xva$0 -> wrapper.add((ItemCapabilityWrapper.ItemCapability)xva$0));
        return wrapper;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return this.f_40379_.m_6646_() > 0 && super.m_8120_(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.m_8120_(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.m_8120_(stack) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @NothingNullByDefault
    protected static class HazmatMaterial
    extends BaseSpecialArmorMaterial {
        protected HazmatMaterial() {
        }

        public String m_6082_() {
            return "mekanism:hazmat";
        }
    }
}

