/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.computercraft.CCArgumentWrapper;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class CCMethodCaller {
    private final BoundComputerMethod[] methods;
    private final String[] methodNames;

    protected CCMethodCaller(Map<String, BoundComputerMethod> boundMethods) {
        this.methods = new BoundComputerMethod[boundMethods.size()];
        this.methodNames = new String[this.methods.length];
        int i = 0;
        for (Map.Entry<String, BoundComputerMethod> entry : boundMethods.entrySet()) {
            this.methodNames[i] = entry.getKey();
            this.methods[i] = entry.getValue();
            ++i;
        }
    }

    protected abstract String getCallerType();

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public MethodResult callMethod(ILuaContext context, int methodIndex, IArguments arguments) throws LuaException {
        if (methodIndex < 0 || methodIndex >= this.methods.length) {
            throw new LuaException(String.format(Locale.ROOT, "Method index '%d' is out of bounds. This %s only has '%d' methods.", methodIndex, this.getCallerType(), this.methods.length));
        }
        BoundComputerMethod method = this.methods[methodIndex];
        CCArgumentWrapper argumentWrapper = new CCArgumentWrapper(arguments);
        BoundComputerMethod.SelectedMethodInfo selectedImplementation = method.findMatchingImplementation(argumentWrapper);
        if (selectedImplementation.getMethod().threadSafe()) {
            return method.run(argumentWrapper, selectedImplementation);
        }
        long task = context.issueMainThreadTask(() -> method.run(argumentWrapper, selectedImplementation).getResult());
        return new TaskCallback((long)task).pull;
    }

    private static class TaskCallback
    implements ILuaCallback {
        private final MethodResult pull = MethodResult.pullEvent((String)"task_complete", (ILuaCallback)this);
        private final long task;

        private TaskCallback(long task) {
            this.task = task;
        }

        @NotNull
        public MethodResult resume(Object[] response) throws LuaException {
            Object object;
            if (response.length >= 3 && (object = response[1]) instanceof Number) {
                Number number = (Number)object;
                object = response[2];
                if (object instanceof Boolean) {
                    Object object2;
                    Boolean bool = (Boolean)object;
                    if (number.longValue() != this.task) {
                        return this.pull;
                    }
                    if (bool.booleanValue()) {
                        return MethodResult.of((Object[])Arrays.copyOfRange(response, 3, response.length));
                    }
                    if (response.length >= 4 && (object2 = response[3]) instanceof String) {
                        String string = (String)object2;
                        throw new LuaException(string);
                    }
                    throw new LuaException("error");
                }
            }
            return this.pull;
        }
    }
}

