/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.measurements.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mrbysco.measurements.client.BoxHandler;
import com.mrbysco.measurements.client.MeasurementBox;
import com.mrbysco.measurements.registration.MeasurementRegistry;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ClientClass {
    public static void onLogIn() {
        BoxHandler.clear();
    }

    public static void onLogOut() {
        BoxHandler.clear();
    }

    public static void onPlayerTick(Player player) {
        if (Minecraft.m_91087_().f_91074_ == player) {
            HitResult rayHit;
            MeasurementBox lastBox;
            if (!player.m_21055_(MeasurementRegistry.TAPE_MEASURE_ITEM.get())) {
                BoxHandler.clear();
                return;
            }
            List<MeasurementBox> boxList = BoxHandler.getBoxList();
            if (boxList.size() > 0 && !(lastBox = boxList.get(boxList.size() - 1)).isFinished() && (rayHit = Minecraft.m_91087_().f_91077_) != null && rayHit.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)rayHit;
                lastBox.setBlockEnd(new BlockPos((Vec3i)blockHitResult.m_82425_()));
            }
        }
    }

    public static void onRenderWorldLast(Player player, Matrix4f projectionMatrix, PoseStack poseStack, RenderBuffers renderBuffers, Camera camera) {
        if (player == null || !player.m_21055_(MeasurementRegistry.TAPE_MEASURE_ITEM.get())) {
            return;
        }
        ResourceKey currentDimension = player.f_19853_.m_46472_();
        poseStack.m_85836_();
        List<MeasurementBox> boxList = BoxHandler.getBoxList();
        boxList.forEach(box -> box.render((ResourceKey<Level>)currentDimension, poseStack, renderBuffers, camera, projectionMatrix));
        poseStack.m_85849_();
    }
}

