/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.conditions.All;
import com.kotori316.limiter.conditions.And;
import com.kotori316.limiter.conditions.Creator;
import com.kotori316.limiter.conditions.DimensionLimit;
import com.kotori316.limiter.conditions.EntityLimit;
import com.kotori316.limiter.conditions.LightLevelLimit;
import com.kotori316.limiter.conditions.MobCategoryLimit;
import com.kotori316.limiter.conditions.MobSpawnTypeLimit;
import com.kotori316.limiter.conditions.Or;
import com.kotori316.limiter.conditions.RandomLimit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import org.apache.commons.lang3.tuple.Pair;

class Rules {
    Rules() {
    }

    static void addAll(List<Pair<String, JsonElement>> list) {
        Rules rules = new Rules();
        Class[] classes = new Class[]{};
        Arrays.stream(rules.getClass().getDeclaredMethods()).filter(m -> (m.getModifiers() & 8) == 0).filter(m -> m.getParameterTypes().length == 0).filter(m -> m.getReturnType() == JsonObject.class).forEach(m -> {
            LimitMobSpawn.LOGGER.info("Generate with {}", (Object)m.getName());
            m.setAccessible(true);
            try {
                list.add(Pair.of((Object)m.getName().toLowerCase(Locale.ROOT), (Object)((JsonObject)m.invoke((Object)rules, new Object[0]))));
            }
            catch (ReflectiveOperationException e) {
                LimitMobSpawn.LOGGER.error((Object)e);
            }
        });
    }

    private static JsonArray as(TestSpawn ... conditions) {
        JsonArray array = new JsonArray();
        for (TestSpawn spawn : conditions) {
            array.add((JsonElement)spawn.toJson());
        }
        return array;
    }

    JsonObject test1() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Conditions in each category are combined by OR.");
        object.add("default", (JsonElement)Rules.as(Creator.entityAtDimension((ResourceKey<Level>)Level.f_46429_, EntityType.f_20511_), new MobCategoryLimit(MobCategory.CREATURE).or(new MobCategoryLimit(MobCategory.MISC)), Creator.posAtDimension((ResourceKey<Level>)Level.f_46430_, -500, 500, -500, 500)));
        object.add("deny", (JsonElement)Rules.as(new DimensionLimit((ResourceKey<Level>)Level.f_46428_), new DimensionLimit((ResourceKey<Level>)Level.f_46429_), new DimensionLimit((ResourceKey<Level>)Level.f_46430_), new EntityLimit(EntityType.f_20549_)));
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)TrueCondition.Serializer.INSTANCE.getJson((ICondition)TrueCondition.INSTANCE));
        object.add("conditions", (JsonElement)conditions);
        return object;
    }

    JsonObject test3() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Conditions in each category are combined by OR.");
        object.add("default", (JsonElement)Rules.as(new MobSpawnTypeLimit(MobSpawnType.SPAWNER), new MobSpawnTypeLimit(MobSpawnType.SPAWN_EGG), new DimensionLimit((ResourceKey<Level>)Level.f_46428_).not().and(new EntityLimit(EntityType.f_20453_))));
        object.add("deny", (JsonElement)Rules.as(new DimensionLimit((ResourceKey<Level>)Level.f_46428_), new DimensionLimit((ResourceKey<Level>)Level.f_46429_), new DimensionLimit((ResourceKey<Level>)Level.f_46430_)));
        object.add("force", (JsonElement)Rules.as(Creator.posAtDimension((ResourceKey<Level>)Level.f_46428_, -64, 64, -64, 64).and(new EntityLimit(EntityType.f_20566_)), Creator.posAtDimension((ResourceKey<Level>)Level.f_46428_, 64, 128, -64, 64).and(new EntityLimit(EntityType.f_20495_))));
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)TrueCondition.Serializer.INSTANCE.getJson((ICondition)TrueCondition.INSTANCE));
        object.add("conditions", (JsonElement)conditions);
        return object;
    }

    JsonObject peaceful() {
        JsonObject object = new JsonObject();
        object.add("deny", (JsonElement)Rules.as(new MobCategoryLimit(MobCategory.MONSTER)));
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)TrueCondition.Serializer.INSTANCE.getJson((ICondition)TrueCondition.INSTANCE));
        object.add("conditions", (JsonElement)conditions);
        return object;
    }

    JsonObject no_bats() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Prevent spawning of bats, except from Spawn Egg.");
        object.add("deny", (JsonElement)Rules.as(new EntityLimit(EntityType.f_20549_).and(new MobSpawnTypeLimit(MobSpawnType.SPAWN_EGG).not())));
        return object;
    }

    JsonObject witch_only() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "In overworld, only witch spawns at night. Other monsters disappeared.");
        object.add("default", (JsonElement)Rules.as(Creator.entityAtDimension((ResourceKey<Level>)Level.f_46428_, EntityType.f_20495_)));
        object.add("deny", (JsonElement)Rules.as(new MobCategoryLimit(MobCategory.MONSTER).and(new DimensionLimit((ResourceKey<Level>)Level.f_46428_))));
        return object;
    }

    JsonObject enderman_only() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "You'll see only Endermans in the world!");
        object.add("force", (JsonElement)Rules.as(new EntityLimit(EntityType.f_20566_)));
        object.add("deny", (JsonElement)Rules.as(All.getInstance()));
        return object;
    }

    JsonObject cancel_spawner() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Cancel all spawns from Monster Spawner");
        object.add("deny", (JsonElement)Rules.as(new MobSpawnTypeLimit(MobSpawnType.SPAWNER)));
        return object;
    }

    JsonObject cancel_70() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Cancel 70% of spawning.");
        object.add("deny", (JsonElement)Rules.as(new And(new RandomLimit(0.7), new Or(new MobSpawnTypeLimit(MobSpawnType.NATURAL), new MobSpawnTypeLimit(MobSpawnType.REINFORCEMENT)))));
        return object;
    }

    JsonObject mining_dim() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Stop spawning of Zombie and Skeleton in 'mining_dimension', which is modded dimension.");
        object.add("deny", (JsonElement)Rules.as(new And(new DimensionLimit((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("mining_dimension:mining"))), new Or(new EntityLimit(EntityType.f_20501_), new EntityLimit(EntityType.f_20524_)))));
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)ModLoadedCondition.Serializer.INSTANCE.getJson((ICondition)new ModLoadedCondition("mining_dimension")));
        object.add("conditions", (JsonElement)conditions);
        return object;
    }

    JsonObject gaia_dim() {
        JsonObject object = new JsonObject();
        object.add("deny", (JsonElement)Rules.as(new DimensionLimit((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("gaiadimension:gaia_dimension"))).and(new Or(new EntityLimit("gaiadimension:agate_golem            ".trim()), new EntityLimit("gaiadimension:ancient_lagrahk        ".trim()), new EntityLimit("gaiadimension:archaic_warrior        ".trim()), new EntityLimit("gaiadimension:blue_howlite_wolf      ".trim()), new EntityLimit("gaiadimension:cavern_tick            ".trim()), new EntityLimit("gaiadimension:contorted_naga         ".trim()), new EntityLimit("gaiadimension:corrupt_sapper         ".trim()), new EntityLimit("gaiadimension:lesser_shockshooter    ".trim()), new EntityLimit("gaiadimension:lesser_spitfire        ".trim()), new EntityLimit("gaiadimension:malachite_drone        ".trim()), new EntityLimit("gaiadimension:malachite_guard        ".trim()), new EntityLimit("gaiadimension:muckling               ".trim()), new EntityLimit("gaiadimension:primal_beast           ".trim()), new EntityLimit("gaiadimension:shalurker              ".trim()), new EntityLimit("gaiadimension:bismuth_uletrus        ".trim()), new EntityLimit("gaiadimension:crystal_golem          ".trim()), new EntityLimit("gaiadimension:growth_sapper          ".trim()), new EntityLimit("gaiadimension:howlite_wolf           ".trim()), new EntityLimit("gaiadimension:mutant_growth_extractor".trim()), new EntityLimit("gaiadimension:nomadic_lagrahk        ".trim()), new EntityLimit("gaiadimension:rocky_luggeroth        ".trim()), new EntityLimit("gaiadimension:rugged_lurmorus        ".trim()), new EntityLimit("gaiadimension:saltion                ".trim()), new EntityLimit("gaiadimension:spellbound_elemental   ".trim()), new EntityLimit("gaiadimension:markuzar_plant         ".trim()), new EntityLimit("gaiadimension:mineral_arenthis       ".trim()), new EntityLimit("gaiadimension:shallow_arenthis       ".trim()), new EntityLimit("gaiadimension:agate_arrow            ".trim()), new EntityLimit("gaiadimension:thrown_pebble          ".trim())))));
        JsonArray conditions = new JsonArray();
        conditions.add((JsonElement)ModLoadedCondition.Serializer.INSTANCE.getJson((ICondition)new ModLoadedCondition("gaiadimension")));
        object.add("conditions", (JsonElement)conditions);
        return object;
    }

    JsonObject allow_only_0() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Stop monsters from spawning in areas whose light level is over 0. As 1.18 do.");
        object.add("deny", (JsonElement)Rules.as(new And(new MobCategoryLimit(MobCategory.MONSTER), new LightLevelLimit(LightLayer.BLOCK, 0))));
        return object;
    }

    JsonObject prevent_natural_monster() {
        JsonObject object = new JsonObject();
        object.addProperty("_comment", "Prevent monsters from spawning naturally.");
        object.add("deny", (JsonElement)Rules.as(new And(new MobCategoryLimit(MobCategory.MONSTER), new Or(new MobSpawnTypeLimit(MobSpawnType.NATURAL), new MobSpawnTypeLimit(MobSpawnType.CHUNK_GENERATION)))));
        return object;
    }
}

