/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.google.common.collect.Sets;
import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;

public record PositionLimit(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) implements TestSpawn
{
    public static final TestSpawn.Serializer<PositionLimit> SERIALIZER = new Serializer();

    public PositionLimit(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        LimitMobSpawn.LOGGER.debug(TestSpawn.MARKER, this.getClass().getSimpleName() + " Instance created with ({},{},{}),({},{},{})", (Object)minX, (Object)minY, (Object)minZ, (Object)maxX, (Object)maxY, (Object)maxZ);
    }

    public PositionLimit(BlockPos pos1, BlockPos pos2) {
        this(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.max(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.max(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()), Math.max(pos1.m_123343_(), pos2.m_123343_()));
    }

    @Override
    public boolean test(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, @Nullable MobSpawnType reason) {
        return this.minX <= pos.m_123341_() && pos.m_123341_() < this.maxX && this.minY <= pos.m_123342_() && pos.m_123342_() < this.maxY && this.minZ <= pos.m_123343_() && pos.m_123343_() < this.maxZ;
    }

    @Override
    public String toString() {
        return "PositionLimit{(" + this.minX + ", " + this.minY + ", " + this.minZ + ") -> (" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")}";
    }

    @Override
    public TestSpawn.Serializer<? extends TestSpawn> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public String contentShort() {
        return "(" + this.minX + ", " + this.minY + ", " + this.minZ + ") -> (" + this.maxX + ", " + this.maxY + ", " + this.maxZ + ")";
    }

    private static class Serializer
    extends TestSpawn.Serializer<PositionLimit> {
        private Serializer() {
        }

        @Override
        public String getType() {
            return "position";
        }

        @Override
        public <T> PositionLimit from(Dynamic<T> dynamic) {
            Map map = dynamic.asMap(d -> d.asString(""), Function.identity());
            if (map.containsKey("pos1") && map.containsKey("pos2")) {
                return (PositionLimit)BlockPos.f_121852_.decode((Dynamic)map.get("pos1")).flatMap(pos1 -> BlockPos.f_121852_.decode((Dynamic)map.get("pos2")).map(pos2 -> new PositionLimit((BlockPos)pos1.getFirst(), (BlockPos)pos2.getFirst()))).getOrThrow(true, s -> LimitMobSpawn.LOGGER.error("Erred when loading PositionLimit, {}", s));
            }
            int minX = ((Dynamic)map.get("minX")).asInt(0);
            int maxX = ((Dynamic)map.get("maxX")).asInt(0);
            int minY = map.getOrDefault("minY", dynamic.createInt(0)).asInt(0);
            int maxY = map.getOrDefault("maxY", dynamic.createInt(256)).asInt(256);
            int minZ = ((Dynamic)map.get("minZ")).asInt(0);
            int maxZ = ((Dynamic)map.get("maxZ")).asInt(0);
            return new PositionLimit(minX, maxX, minY, maxY, minZ, maxZ);
        }

        @Override
        public <T> T to(TestSpawn t, DynamicOps<T> ops) {
            PositionLimit l = (PositionLimit)t;
            HashMap map = new HashMap();
            BlockPos.f_121852_.encodeStart(ops, (Object)new BlockPos(l.minX, l.minY, l.minZ)).result().ifPresent(pos1 -> map.put(ops.createString("pos1"), pos1));
            BlockPos.f_121852_.encodeStart(ops, (Object)new BlockPos(l.maxX, l.maxY, l.maxZ)).result().ifPresent(pos2 -> map.put(ops.createString("pos2"), pos2));
            return (T)ops.createMap(map);
        }

        @Override
        public Set<String> propertyKeys() {
            return Sets.newHashSet((Object[])new String[]{"minX", "maxX", "minY", "maxY", "minZ", "maxZ"});
        }

        @Override
        public Set<String> possibleValues(String property, boolean suggesting, SharedSuggestionProvider provider) {
            return Collections.emptySet();
        }
    }
}

