/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.conditions.StringLimitSerializer;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public record BiomeLimit(@Nonnull ResourceKey<Biome> biomeResourceKey) implements TestSpawn
{
    public static final TestSpawn.Serializer<BiomeLimit> SERIALIZER = new BiomeSerializer();

    public BiomeLimit(@Nonnull ResourceKey<Biome> biomeResourceKey) {
        this.biomeResourceKey = biomeResourceKey;
        LimitMobSpawn.LOGGER.debug(TestSpawn.MARKER, this.getClass().getSimpleName() + " Instance created with {}", biomeResourceKey);
    }

    public BiomeLimit(@Nonnull ResourceLocation biome) {
        this((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome));
    }

    @Override
    public boolean test(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, @Nullable MobSpawnType reason) {
        if (worldIn instanceof LevelReader) {
            LevelReader worldReader = (LevelReader)worldIn;
            Holder biome = worldReader.m_204166_(pos);
            return this.test((Biome)biome.m_203334_());
        }
        return false;
    }

    public boolean test(Biome biome) {
        return this.biomeResourceKey.m_135782_().equals((Object)ForgeRegistries.BIOMES.getKey((Object)biome));
    }

    @Override
    public TestSpawn.Serializer<? extends TestSpawn> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public String contentShort() {
        return "biome " + this.biomeResourceKey.m_135782_();
    }

    private static final class BiomeSerializer
    extends StringLimitSerializer<BiomeLimit, ResourceKey<Biome>> {
        private BiomeSerializer() {
        }

        @Override
        public String getType() {
            return "biome";
        }

        @Override
        public Set<String> possibleValues(String property, boolean suggesting, @Nullable SharedSuggestionProvider provider) {
            return this.suggestions(property, provider).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        }

        @Override
        public Set<ResourceLocation> suggestions(String property, @Nullable SharedSuggestionProvider provider) {
            if (provider == null || !property.equals(this.saveKey())) {
                return Collections.emptySet();
            }
            return provider.m_5894_().m_175515_(Registry.f_122885_).m_6566_();
        }

        @Override
        public ResourceKey<Biome> fromString(String s) {
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s));
        }

        @Override
        public String valueToString(ResourceKey<Biome> biomeResourceKey) {
            return biomeResourceKey.m_135782_().toString();
        }

        @Override
        public String saveKey() {
            return "biome";
        }

        @Override
        public BiomeLimit instance(ResourceKey<Biome> biomeResourceKey) {
            return new BiomeLimit(biomeResourceKey);
        }

        @Override
        public ResourceKey<Biome> getter(BiomeLimit dimensionLimit) {
            return dimensionLimit.biomeResourceKey;
        }
    }
}

