/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter;

import com.kotori316.limiter.Config;
import com.kotori316.limiter.SpawnConditionLoader;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.capability.Caps;
import com.kotori316.limiter.capability.LMSHandler;
import com.kotori316.limiter.command.LMSCommand;
import com.kotori316.limiter.command.TestSpawnArgument;
import com.mojang.brigadier.CommandDispatcher;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="limitmobspawn")
public class LimitMobSpawn {
    public static final String MOD_ID = "limitmobspawn";
    public static final Logger LOGGER = LogManager.getLogger((String)"limitmobspawn");
    public static final Level LOG_LEVEL = Boolean.getBoolean("limit-mob-spawn") ? Level.DEBUG : Level.TRACE;

    public LimitMobSpawn() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::register);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(LMSHandler::registerCapability);
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.getInstance().setup(common));
    }

    public void register(RegisterEvent event) {
        event.register(Registry.f_235724_, new ResourceLocation("limitmobspawn:rule"), TestSpawnArgument::registerArgumentType);
    }

    @SubscribeEvent
    public void addLister(AddReloadListenerEvent event) {
        SpawnConditionLoader.INSTANCE.setContext(event.getServerResources().getConditionContext());
        event.addListener((PreparableReloadListener)SpawnConditionLoader.INSTANCE);
    }

    @SubscribeEvent
    public void addCommand(RegisterCommandsEvent event) {
        LMSCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static SpawnCheckResult allowSpawning(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, @Nullable MobSpawnType reason) {
        LazyOptional maybeHandler = worldIn instanceof ICapabilityProvider ? ((ICapabilityProvider)worldIn).getCapability(Caps.getLmsCapability()) : LazyOptional.empty();
        boolean matchForce = LMSHandler.getCombinedForce(SpawnConditionLoader.INSTANCE.getHolder(), (LazyOptional<LMSHandler>)maybeHandler).filter(TestSpawn::isDeterministic).anyMatch(spawn -> spawn.test(worldIn, pos, entityTypeIn, reason));
        if (matchForce) {
            return SpawnCheckResult.FORCE;
        }
        boolean matchDefault = LMSHandler.getCombinedDefault(SpawnConditionLoader.INSTANCE.getHolder(), (LazyOptional<LMSHandler>)maybeHandler).filter(TestSpawn::isDeterministic).anyMatch(spawn -> spawn.test(worldIn, pos, entityTypeIn, reason));
        if (matchDefault) {
            return SpawnCheckResult.DEFAULT;
        }
        boolean matchDeny = LMSHandler.getCombinedDeny(SpawnConditionLoader.INSTANCE.getHolder(), (LazyOptional<LMSHandler>)maybeHandler).filter(TestSpawn::isDeterministic).anyMatch(spawn -> spawn.test(worldIn, pos, entityTypeIn, reason));
        if (matchDeny) {
            return SpawnCheckResult.DENY;
        }
        return SpawnCheckResult.DEFAULT;
    }

    public static enum SpawnCheckResult {
        DENY,
        DEFAULT,
        FORCE;

    }
}

