/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandler;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;

public class BlockBreakPlaceRegistry
implements IBlockPlaceHandlerRegistry {
    private static BlockBreakPlaceRegistry INSTANCE = new BlockBreakPlaceRegistry();
    private final Multimap<Item, IBlockPlaceHandler> handlers = Multimaps.newSetMultimap((Map)Maps.newIdentityHashMap(), Sets::newIdentityHashSet);

    private BlockBreakPlaceRegistry() {
    }

    public static BlockBreakPlaceRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public IBlockPlaceHandler register(Item item, IBlockPlaceHandler placeAction) {
        this.handlers.put((Object)item, (Object)placeAction);
        return placeAction;
    }

    @Override
    public Collection<IBlockPlaceHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.handlers.values());
    }

    @Override
    public Collection<IBlockPlaceHandler> getHandlers(Item item) {
        return Collections.unmodifiableCollection(this.handlers.get((Object)item));
    }

    @Override
    @Nullable
    public IBlockPlaceHandler getHandler(ItemStack itemStack, Level world, BlockPos pos, Direction side, float hitX, float hitY, float hitZ, Player player) {
        for (IBlockPlaceHandler placeHandler : this.getHandlers(itemStack.m_41720_())) {
            if (!placeHandler.shouldApply(itemStack, world, pos, side, hitX, hitY, hitZ, player)) continue;
            return placeHandler;
        }
        return null;
    }
}

