/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneHolderGlobal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class MixinLevel {
    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/level/Level;getSignal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)I"}, cancellable=true)
    public void getSignal(BlockPos pos, Direction facing, CallbackInfoReturnable<Integer> callback) {
        IDynamicRedstone dynamicRedstone;
        int value;
        int originalReturn = (Integer)callback.getReturnValue();
        if (originalReturn >= 15) {
            callback.setReturnValue((Object)originalReturn);
            return;
        }
        DynamicRedstoneHolderGlobal instance = DynamicRedstoneHolderGlobal.getInstance();
        if (instance.hasLevels() && (value = (dynamicRedstone = instance.getDynamicRedstone(DimPos.of((Level)((Level)this), (BlockPos)pos), facing)).getRedstoneLevel()) > 0) {
            callback.setReturnValue((Object)Math.max(originalReturn, value));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/level/Level;getDirectSignalTo(Lnet/minecraft/core/BlockPos;)I"}, cancellable=true)
    public void getDirectSignalTo(BlockPos pos, CallbackInfoReturnable<Integer> callback) {
        int originalReturn = (Integer)callback.getReturnValue();
        if (originalReturn >= 15) {
            callback.setReturnValue((Object)originalReturn);
            return;
        }
        DynamicRedstoneHolderGlobal instance = DynamicRedstoneHolderGlobal.getInstance();
        if (instance.hasLevels()) {
            int i = 0;
            if ((i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_7495_(), Direction.DOWN))) >= 15) {
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            } else if ((i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_7494_(), Direction.UP))) >= 15) {
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            } else if ((i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_122012_(), Direction.NORTH))) >= 15) {
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            } else if ((i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_122019_(), Direction.SOUTH))) >= 15) {
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            } else if ((i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_122024_(), Direction.WEST))) >= 15) {
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            } else {
                i = Math.max(i, this.getDirectSignalGlobal(instance, pos.m_122029_(), Direction.EAST));
                callback.setReturnValue((Object)Math.max(originalReturn, i));
            }
        }
    }

    private int getDirectSignalGlobal(DynamicRedstoneHolderGlobal instance, BlockPos pos, Direction facing) {
        int value;
        IDynamicRedstone dynamicRedstone = instance.getDynamicRedstone(DimPos.of((Level)((Level)this), (BlockPos)pos), facing);
        if (dynamicRedstone.isDirect() && (value = dynamicRedstone.getRedstoneLevel()) > 0) {
            return value;
        }
        return 0;
    }
}

