/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.multiblocks;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.CokerUnitTileEntity;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.CCTUtils;
import flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.multiblocks.generic.PoweredMultiblockPeripheral;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CokerUnitPeripheral
extends PoweredMultiblockPeripheral {
    CokerUnitTileEntity master;

    public CokerUnitPeripheral(CokerUnitTileEntity coker) {
        super(coker);
        this.master = (CokerUnitTileEntity)coker.master();
    }

    public String getType() {
        return "ip_cokerunit";
    }

    @LuaFunction
    public final Map<String, Object> getChamberA() {
        return this.getChamber(0);
    }

    @LuaFunction
    public final Map<String, Object> getChamberB() {
        return this.getChamber(1);
    }

    private Map<String, Object> getChamber(int id) {
        CokerUnitTileEntity.CokingChamber chamber = this.master.chambers[id];
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation rl = RegistryUtils.getRegistryNameOf(chamber.getInputItem().m_41720_());
        String regName = rl == null ? null : rl.toString();
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("name", regName);
        inputMap.put("count", chamber.getInputAmount());
        map.put("input", inputMap);
        rl = RegistryUtils.getRegistryNameOf(chamber.getOutputItem().m_41720_());
        regName = rl == null ? null : rl.toString();
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        outputMap.put("name", regName);
        outputMap.put("count", chamber.getOutputAmount());
        map.put("output", outputMap);
        map.put("state", chamber.getState().toString());
        map.put("tank", CCTUtils.fluidToMap(chamber.getTank().getFluid()));
        map.put("tankCapacity", chamber.getTank().getCapacity());
        map.put("itemCapacity", chamber.getCapacity());
        return map;
    }

    @LuaFunction
    public final MethodResult getTankSize(int tank) {
        switch (tank) {
            case 1: 
            case 2: {
                return MethodResult.of((Object)this.master.bufferTanks[tank - 1].getCapacity());
            }
        }
        return MethodResult.of((Object[])new Object[]{null, "Index " + tank + " out of Bounds."});
    }

    @LuaFunction
    public final Map<String, Object> getInputTank() {
        return CCTUtils.fluidToMap(this.master.bufferTanks[0].getFluid());
    }

    @LuaFunction
    public final Map<String, Object> getOutputTank() {
        return CCTUtils.fluidToMap(this.master.bufferTanks[1].getFluid());
    }
}

