/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class IPItemStackHandler
extends ItemStackHandler
implements ICapabilityProvider {
    private static final Runnable EMPTY_RUN = () -> {};
    @Nonnull
    private Runnable onChange = EMPTY_RUN;
    LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this);

    public IPItemStackHandler(int invSize) {
        super(invSize);
    }

    public void setTile(BlockEntity tile) {
        this.onChange = tile != null ? () -> ((BlockEntity)tile).m_6596_() : EMPTY_RUN;
    }

    public void setInventoryForUpdate(Container inv) {
        this.onChange = inv != null ? () -> ((Container)inv).m_6596_() : EMPTY_RUN;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.onChange.run();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return LazyOptional.empty();
    }

    public NonNullList<ItemStack> getContainedItems() {
        return this.stacks;
    }
}

