/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.client.gui.SeismicSurveyScreen;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.IslandInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class SurveyResultItem
extends IPItemBase {
    public SurveyResultItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String selfKey = this.m_5671_(stack);
        return Component.m_237115_((String)selfKey).m_130940_(ChatFormatting.GOLD);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ISurveyInfo iSurveyInfo;
        ItemStack held = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_ && (iSurveyInfo = ISurveyInfo.from(held)) instanceof SurveyScan) {
            SurveyScan scan = (SurveyScan)iSurveyInfo;
            if (scan.getUuid() == null) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"This survey is faulty. (Destroy me!)").m_130940_(ChatFormatting.RED), true);
                return InteractionResultHolder.m_19100_((Object)held);
            }
            SurveyResultItem.openGUI(pLevel, scan);
            return InteractionResultHolder.m_19090_((Object)held);
        }
        return InteractionResultHolder.m_19098_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openGUI(Level level, @Nonnull SurveyScan scan) {
        MCUtil.setScreen(new SeismicSurveyScreen(level, scan));
    }

    public void m_7373_(ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_() != null) {
            ISurveyInfo info = ISurveyInfo.from(stack);
            if (info instanceof SurveyScan) {
                SurveyScan scan = (SurveyScan)info;
                if (scan.getUuid() == null) {
                    tooltip.add((Component)Component.m_237113_((String)"SORRY, IM FAULTY!").m_130940_(ChatFormatting.RED));
                    tooltip.add((Component)Component.m_237113_((String)"YOU'LL HAVE TO TOSS ME!").m_130940_(ChatFormatting.RED));
                    return;
                }
                tooltip.add((Component)Component.m_237115_((String)"desc.immersivepetroleum.flavour.surveytool.rightclickme"));
                if (flagIn == TooltipFlag.Default.ADVANCED) {
                    tooltip.add((Component)Component.m_237113_((String)("ID: " + (scan.getUuid() != null ? scan.getUuid().toString() : "Null"))));
                    tooltip.add((Component)Component.m_237113_((String)("dSize: " + (Serializable)(scan.getData() != null ? Integer.valueOf(scan.getData().length) : "Null"))));
                }
            }
            if (info instanceof IslandInfo) {
                IslandInfo islandInfo = (IslandInfo)info;
                int expected = islandInfo.getExpected();
                long amount = islandInfo.getAmount();
                byte percentage = islandInfo.getStatus();
                FluidStack fs = islandInfo.getFluidStack();
                if (islandInfo.getFluidStack() == FluidStack.EMPTY) {
                    tooltip.add((Component)Component.m_237113_((String)"SORRY, IM FAULTY!").m_130940_(ChatFormatting.RED));
                    tooltip.add((Component)Component.m_237113_((String)"YOU'LL HAVE TO TOSS ME!").m_130940_(ChatFormatting.RED));
                    return;
                }
                tooltip.add((Component)Component.m_237115_((String)fs.getTranslationKey()).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237110_((String)"desc.immersivepetroleum.info.survey_result.amount", (Object[])new Object[]{String.format(Locale.ENGLISH, "%,.3f", (double)amount / 1000.0), percentage}).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237110_((String)"desc.immersivepetroleum.info.survey_result.expected", (Object[])new Object[]{expected}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (info != null) {
                int x = info.getX();
                int z = info.getZ();
                tooltip.add((Component)Component.m_237110_((String)"desc.immersivepetroleum.flavour.surveytool.location", (Object[])new Object[]{x, z}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

