/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.fluids.NapalmFluid;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class CommonEventHandler {
    static final Random random = new Random();
    public static final Map<ResourceLocation, List<BlockPos>> napalmPositions = new HashMap<ResourceLocation, List<BlockPos>>();
    public static final Map<ResourceLocation, List<BlockPos>> toRemove = new HashMap<ResourceLocation, List<BlockPos>>();

    @SubscribeEvent
    public void onSave(LevelEvent.Save event) {
        if (!event.getLevel().m_5776_()) {
            IPSaveData.markDirty();
        }
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            IPSaveData.markDirty();
            ReservoirRegionDataStorage.get().markAllDirty();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerStopped(ServerStoppedEvent event) {
        ImmersivePetroleum.log.debug("[ReservoirIslands]: Clearing Cache...");
        ReservoirHandler.clearCache();
    }

    @SubscribeEvent
    public void handleBoatImmunity(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.f_19308_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19305_) {
            LivingEntity entity = event.getEntity();
            Entity entity2 = entity.m_20202_();
            if (entity2 instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity2;
                if (boat.isFireproof) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (entity.m_20094_() > 0 && entity.m_21124_((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get()) != null) {
                entity.m_20095_();
                entity.m_21195_((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(TickEvent.PlayerTickEvent event) {
        Entity entity;
        Player entity2 = event.player;
        if (entity2.m_6060_() && (entity = entity2.m_20202_()) instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity;
            if (boat.isFireproof) {
                entity2.m_20095_();
                boat.m_20115_(0, false);
            }
        }
    }

    @SubscribeEvent
    public void handleDismountingBoat(EntityMountEvent event) {
        if (event.getEntityMounting() == null) {
            return;
        }
        Entity entity = event.getEntityMounting();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = event.getEntityBeingMounted();
            if (entity instanceof MotorboatEntity) {
                FluidState fluidstate;
                MotorboatEntity boat = (MotorboatEntity)entity;
                if (event.isDismounting() && boat.isFireproof && (fluidstate = event.getLevel().m_8055_(new BlockPos(boat.m_20182_().m_82520_(0.5, 0.0, 0.5))).m_60819_()) != Fluids.f_76191_.m_76145_() && fluidstate.m_205070_(FluidTags.f_13132_)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get(), 1, 0, false, false));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLubricatingMachinesServer(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CommonEventHandler.handleLubricatingMachines(event.level);
        }
    }

    public static void handleLubricatingMachines(Level world) {
        HashSet<LubricatedHandler.LubricatedTileInfo> toRemove = new HashSet<LubricatedHandler.LubricatedTileInfo>();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            BlockEntity te;
            LubricatedHandler.ILubricationHandler<BlockEntity> lubeHandler;
            if (info.world != world.m_46472_() || !world.isAreaLoaded(info.pos, 0) || (lubeHandler = LubricatedHandler.getHandlerForTile(te = world.m_7702_(info.pos))) == null) continue;
            if (lubeHandler.isMachineEnabled(world, te)) {
                if (world.f_46443_) {
                    lubeHandler.lubricateClient((ClientLevel)world, info.lubricant, info.ticks, te);
                } else {
                    lubeHandler.lubricateServer((ServerLevel)world, info.lubricant, info.ticks, te);
                }
            }
            if (world.f_46443_ && te instanceof MultiblockPartBlockEntity) {
                MultiblockPartBlockEntity part = (MultiblockPartBlockEntity)te;
                Vec3i size = lubeHandler.getStructureDimensions();
                int numBlocks = (int)((float)(size.m_123341_() * size.m_123342_() * size.m_123343_()) * 0.25f);
                for (int i = 0; i < numBlocks; ++i) {
                    MultiblockPartBlockEntity part2;
                    Object object;
                    BlockPos pos = part.getBlockPosForPos(new BlockPos((double)((float)size.m_123341_() * random.nextFloat()), (double)((float)size.m_123342_() * random.nextFloat()), (double)((float)size.m_123343_() * random.nextFloat())));
                    if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || !((object = world.m_7702_(pos)) instanceof MultiblockPartBlockEntity) || (part2 = (MultiblockPartBlockEntity)object).master() != part.master()) continue;
                    object = Direction.Plane.HORIZONTAL.iterator();
                    while (object.hasNext()) {
                        Direction facing = (Direction)object.next();
                        if (world.f_46441_.m_188503_(30) != 0) continue;
                        Vec3i direction = facing.m_122436_();
                        float x = (float)pos.m_123341_() + 0.5f + (float)direction.m_123341_() * 0.65f;
                        float y = pos.m_123342_() + 1;
                        float z = (float)pos.m_123343_() + 0.5f + (float)direction.m_123343_() * 0.65f;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (info.ticks-- > 0) continue;
            toRemove.add(info);
        }
        for (LubricatedHandler.LubricatedTileInfo info : toRemove) {
            LubricatedHandler.lubricatedTiles.remove(info);
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEntity() instanceof FakePlayer) {
                return;
            }
            if (((Boolean)IPServerConfig.MISCELLANEOUS.autounlock_recipes.get()).booleanValue()) {
                ArrayList l = new ArrayList();
                Collection recipes = event.getLevel().m_7465_().m_44051_();
                recipes.forEach(recipe -> {
                    ResourceLocation name = recipe.m_6423_();
                    if (name.m_135827_().equals("immersivepetroleum")) {
                        l.add(recipe);
                    }
                });
                player.m_7281_(l);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Skeleton) {
            DamageSource src;
            Entity entity;
            Skeleton skelly = (Skeleton)livingEntity;
            if (!skelly.f_19853_.f_46443_ && (entity = (src = event.getSource()).m_7639_()) instanceof Player) {
                Entity entity2;
                Player player = (Player)entity;
                if (!player.f_19853_.f_46443_ && (entity2 = player.m_20202_()) instanceof MotorboatEntity) {
                    MotorboatEntity motorboat = (MotorboatEntity)entity2;
                    if (!motorboat.f_19853_.f_46443_ && src.m_19360_() && motorboat.isSpinningFastEnough() && motorboat.hasRudders) {
                        Utils.unlockIPAdvancement(player, "main/rudders");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleNapalm(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        ResourceLocation d = event.level.m_46472_().m_135782_();
        switch (event.phase) {
            case START: {
                if (napalmPositions.get(d) == null) break;
                List trList = toRemove.computeIfAbsent(d, f -> new ArrayList());
                new ArrayList<BlockPos>((Collection)napalmPositions.get(d)).forEach(pos -> {
                    LiquidBlock fluidBlock;
                    BlockState state = event.level.m_8055_(pos);
                    Block patt9339$temp = state.m_60734_();
                    if (patt9339$temp instanceof LiquidBlock && (fluidBlock = (LiquidBlock)patt9339$temp) == IPContent.Fluids.NAPALM.block().get()) {
                        NapalmFluid.processFire(IPContent.Fluids.NAPALM, event.level, pos);
                    }
                    trList.add(pos);
                });
                break;
            }
            case END: {
                if (toRemove.get(d) == null || napalmPositions.get(d) == null) break;
                ArrayList list = new ArrayList(toRemove.get(d));
                napalmPositions.get(d).removeAll(list);
                toRemove.get(d).clear();
            }
        }
    }
}

