/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoresampleBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds {
    public ItemStack coresample = ItemStack.f_41583_;
    private Component[] overlay = null;
    private static final VoxelShape AABB_CORESAMPLE_X = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.28125, (double)1.0, (double)1.0, (double)0.71875);
    private static final VoxelShape AABB_CORESAMPLE_Z = Shapes.m_83048_((double)0.28125, (double)0.0, (double)0.0, (double)0.71875, (double)1.0, (double)1.0);

    public CoresampleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CORE_SAMPLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.coresample = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("coresample"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128365_("coresample", (Tag)this.coresample.m_41739_(new CompoundTag()));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        ColumnPos coords = CoresampleItem.getCoords(this.coresample);
        if (player.m_6144_()) {
            if (!this.f_58857_.f_46443_) {
                ItemEntity entityitem = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, this.coresample);
                entityitem.m_32060_();
                this.f_58857_.m_7471_(this.f_58858_, false);
                this.f_58857_.m_7967_((Entity)entityitem);
            }
            return true;
        }
        if (!heldItem.m_41619_() && heldItem.m_41720_() == Items.f_42573_ && coords != null) {
            MapItemSavedData mapData;
            if (!this.f_58857_.f_46443_ && (mapData = MapItem.m_42853_((ItemStack)heldItem, (Level)player.m_20193_())) != null) {
                if (mapData.f_77887_ != CoresampleItem.getDimension(this.coresample)) {
                    player.m_213846_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.coresample.mapDimension"));
                    return true;
                }
                String ident = "ie:coresample_" + coords;
                CompoundTag mapTagCompound = heldItem.m_41784_();
                ListTag nbttaglist = mapTagCompound.m_128437_("Decorations", 10);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundTag tagCompound = (CompoundTag)nbttaglist.get(i);
                    if (!ident.equalsIgnoreCase(tagCompound.m_128461_("id"))) continue;
                    nbttaglist.remove(i);
                    mapTagCompound.m_128365_("Decorations", (Tag)nbttaglist);
                    return true;
                }
                double sampleX = (double)coords.f_140723_() + 0.5;
                double sampleZ = (double)coords.f_140724_() + 0.5;
                int mapScale = 1 << mapData.f_77890_;
                float distX = (float)(sampleX - (double)mapData.f_77885_) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.f_77886_) / (float)mapScale;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    CompoundTag tagCompound = new CompoundTag();
                    tagCompound.m_128359_("id", ident);
                    tagCompound.m_128344_("type", MapDecoration.Type.TARGET_POINT.m_77853_());
                    tagCompound.m_128347_("x", sampleX);
                    tagCompound.m_128347_("z", sampleZ);
                    tagCompound.m_128347_("rot", 180.0);
                    tagCompound.m_128365_("minerals", (Tag)CoresampleItem.getSimplifiedMineralList(this.f_58857_, this.coresample));
                    nbttaglist.add((Object)tagCompound);
                    mapTagCompound.m_128365_("Decorations", (Tag)nbttaglist);
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.coresample.mapFail"));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Component getDisplayName() {
        if (this.coresample.m_41788_()) {
            return this.coresample.m_41786_();
        }
        return Component.m_237115_((String)"item.immersiveengineering.coresample.name");
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        return ImmutableList.of((Object)this.coresample);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.coresample = ctx.m_43722_().m_41777_();
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (this.overlay == null) {
            ArrayList<Component> list = new ArrayList<Component>();
            CoresampleItem.getCoresampleInfo(this.coresample, list, ChatFormatting.WHITE, this.f_58857_, false, false);
            this.overlay = list.toArray(new Component[0]);
        }
        return this.overlay;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getFacing().m_122434_() == Direction.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
    }
}

