/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.client.render.conveyor.VerticalConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.ItemEntityAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;

public class VerticalConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "vertical");
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/vertical");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/vertical_off");
    public static IConveyorType<VerticalConveyor> TYPE = new BasicConveyorType<VerticalConveyor>(NAME, false, true, VerticalConveyor::new, () -> new VerticalConveyorRender(texture_on, texture_off));
    private CapabilityReference<IItemHandler> inserter;
    private static final CachedShapesWithTransform<Boolean, Direction> SHAPES = CachedShapesWithTransform.createDirectional(bottomBelt -> {
        ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125)});
        if (bottomBelt.booleanValue()) {
            list.add(conveyorBounds.m_83215_());
        }
        return list;
    });
    private static final CachedShapesWithTransform<CoveredShapeKey, Direction> COVERED_SHAPES = CachedShapesWithTransform.createDirectional(key -> {
        ArrayList<AABB> list = new ArrayList<AABB>();
        list.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
        list.add(new AABB(0.0, key.leftWall ? 0.0 : 0.75, 0.0, 0.0625, 1.0, 1.0));
        list.add(new AABB(0.9375, key.rightWall ? 0.0 : 0.75, 0.0, 1.0, 1.0, 1.0));
        list.add(new AABB(0.0, key.frontConveyor ? 0.0 : 0.75, 0.9375, 1.0, 1.0, 1.0));
        if (key.bottomBelt) {
            list.add(conveyorBounds.m_83215_());
        }
        return list;
    });

    public VerticalConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<VerticalConveyor> getType() {
        return TYPE;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public Direction[] sigTransportDirections() {
        return new Direction[]{Direction.UP, this.getFacing()};
    }

    @Override
    public Vec3 getDirection(Entity entity, boolean outputBlocked) {
        BlockPos posWall = this.getBlockEntity().m_58899_().m_121945_(this.getFacing());
        double d = 0.625 + (double)entity.m_20205_();
        double distToWall = Math.abs((double)(this.getFacing().m_122434_() == Direction.Axis.Z ? posWall.m_123343_() : posWall.m_123341_()) + 0.5 - (this.getFacing().m_122434_() == Direction.Axis.Z ? entity.m_20189_() : entity.m_20185_()));
        if (distToWall > d) {
            return super.getDirection(entity, outputBlocked);
        }
        double vBase = entity instanceof LivingEntity ? 1.5 : 1.15;
        double distY = Math.abs((double)this.getBlockEntity().m_58899_().m_7918_(0, 1, 0).m_123342_() + 0.5 - entity.m_20186_());
        double treshold = 0.9;
        boolean contact = distY < treshold;
        double vX = entity.m_20184_().f_82479_;
        double vY = 0.1 * vBase;
        double vZ = entity.m_20184_().f_82481_;
        if (entity.m_20184_().f_82480_ < 0.0) {
            vY += entity.m_20184_().f_82480_ * 0.9;
        }
        if (!(entity instanceof Player)) {
            vX = 0.05 * (double)this.getFacing().m_122429_();
            vZ = 0.05 * (double)this.getFacing().m_122431_();
            if (this.getFacing() == Direction.WEST || this.getFacing() == Direction.EAST) {
                if (entity.m_20189_() > (double)this.getBlockEntity().m_58899_().m_123343_() + 0.65) {
                    vZ = -0.1 * vBase;
                } else if (entity.m_20189_() < (double)this.getBlockEntity().m_58899_().m_123343_() + 0.35) {
                    vZ = 0.1 * vBase;
                }
            } else if (this.getFacing() == Direction.NORTH || this.getFacing() == Direction.SOUTH) {
                if (entity.m_20185_() > (double)this.getBlockEntity().m_58899_().m_123341_() + 0.65) {
                    vX = -0.1 * vBase;
                } else if (entity.m_20185_() < (double)this.getBlockEntity().m_58899_().m_123341_() + 0.35) {
                    vX = 0.1 * vBase;
                }
            }
        }
        BlockPos upForward = this.getBlockEntity().m_58899_().m_7918_(0, 1, 0);
        if (contact && !(Utils.getExistingTileEntity(this.getBlockEntity().m_58904_(), upForward) instanceof ConveyorHandler.IConveyorBlockEntity)) {
            vY *= 2.25;
        }
        return new Vec3(vX, vY, vZ);
    }

    @Override
    public void onEntityCollision(@Nonnull Entity entity) {
        boolean hasBeenHandled;
        double treshold;
        this.collisionTracker.onEntityCollided(entity);
        if (!this.isActive() || !entity.m_6084_()) {
            return;
        }
        if (entity instanceof Player && entity.m_6144_()) {
            return;
        }
        BlockPos posWall = this.getBlockEntity().m_58899_().m_121945_(this.getFacing());
        double d = 0.625 + (double)entity.m_20205_();
        double distToWall = Math.abs((double)(this.getFacing().m_122434_() == Direction.Axis.Z ? posWall.m_123343_() : posWall.m_123341_()) + 0.5 - (this.getFacing().m_122434_() == Direction.Axis.Z ? entity.m_20189_() : entity.m_20185_()));
        if (distToWall > d) {
            super.onEntityCollision(entity);
            return;
        }
        boolean outputBlocked = this.isOutputBlocked();
        double distY = Math.abs((double)this.getBlockEntity().m_58899_().m_7918_(0, 1, 0).m_123342_() + 0.5 - entity.m_20186_());
        boolean contact = distY < (treshold = 0.9);
        entity.m_6853_(false);
        entity.f_19789_ = entity.f_19789_ < 3.0f ? 0.0f : (float)((double)entity.f_19789_ * 0.9);
        Vec3 vec = this.getDirection(entity, outputBlocked);
        boolean bl = hasBeenHandled = !ConveyorHandler.markEntityAsHandled(entity);
        if (outputBlocked && entity.m_20186_() >= (double)this.getBlockEntity().m_58899_().m_123342_() + 0.25) {
            double my = entity.m_20186_() < entity.f_19791_ ? entity.f_19791_ - entity.m_20186_() : entity.m_20184_().f_82480_;
            vec = hasBeenHandled ? new Vec3(vec.f_82479_, my, vec.f_82481_) : new Vec3(0.0, my, 0.0);
        }
        entity.m_20256_(vec);
        if (!contact) {
            ConveyorHandler.applyMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
        } else {
            BlockPos posTop = this.getBlockEntity().m_58899_().m_7918_(0, 1, 0);
            if (!(this.getBlockEntity().m_58904_().m_7702_(posTop) instanceof ConveyorHandler.IConveyorBlockEntity || this.getBlockEntity().m_58904_().m_46859_(posTop) && this.getBlockEntity().m_58904_().m_7702_(posTop.m_121945_(this.getFacing())) instanceof ConveyorHandler.IConveyorBlockEntity)) {
                ConveyorHandler.revertMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
            }
        }
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (!contact) {
                if (item.m_32059_() > item.lifespan - 1200) {
                    ((ItemEntityAccess)item).setAge(item.lifespan - 1200);
                }
            } else {
                BlockPos outputPos = this.getBlockEntity().m_58899_().m_7918_(0, 1, 0);
                BlockEntity inventoryTile = this.getBlockEntity().m_58904_().m_7702_(outputPos);
                if (!this.getBlockEntity().m_58904_().f_46443_ && !(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                    ItemUtils.tryInsertEntity(this.getBlockEntity().m_58904_(), outputPos, Direction.DOWN, item);
                }
            }
        }
        if (this.isCovered() && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            item.m_32010_(10);
        }
    }

    @Override
    public BlockPos getOutputInventory() {
        return this.getBlockEntity().m_58899_().m_7494_();
    }

    @Override
    public List<BlockPos> getNextConveyorCandidates() {
        BlockPos pos = this.getBlockEntity().m_58899_();
        return ImmutableList.of((Object)pos.m_7494_(), (Object)pos.m_7494_().m_121945_(this.getFacing()));
    }

    @Override
    public VoxelShape getSelectionShape() {
        return this.getCollisionShape();
    }

    @Override
    public VoxelShape getCollisionShape() {
        Direction facing = this.getFacing();
        if (!this.isCovered()) {
            return SHAPES.get(Pair.of((Object)VerticalConveyor.renderBottomBelt(this.getBlockEntity(), facing), (Object)facing));
        }
        return COVERED_SHAPES.get(new CoveredShapeKey(VerticalConveyor.renderBottomBelt(this.getBlockEntity(), facing), this.isSideOpen(ConveyorWall.LEFT.getWallSide(facing)), this.isSideOpen(ConveyorWall.RIGHT.getWallSide(facing)), this.isSideOpen(facing.m_122424_())), facing);
    }

    private boolean isSideOpen(Direction side) {
        BlockPos pos = this.getBlockEntity().m_58899_().m_121945_(side);
        return ConveyorHandler.connectsToConveyor(this.getBlockEntity().m_58904_(), pos, side);
    }

    public static boolean isInwardConveyor(BlockEntity bEntity, Direction f) {
        ConveyorHandler.IConveyorBlockEntity convBE;
        Object sub;
        BlockEntity te = bEntity.m_58904_().m_7702_(bEntity.m_58899_().m_121945_(f));
        if (te instanceof ConveyorHandler.IConveyorBlockEntity && (sub = (convBE = (ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance()) != null) {
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f != f2.m_122424_()) continue;
                return true;
            }
        }
        if ((te = bEntity.m_58904_().m_7702_(bEntity.m_58899_().m_7918_(0, -1, 0).m_121945_(f))) instanceof ConveyorHandler.IConveyorBlockEntity && (sub = (convBE = (ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance()) != null) {
            int b = 0;
            for (Direction f2 : sub.sigTransportDirections()) {
                if (f == f2.m_122424_()) {
                    ++b;
                } else if (Direction.UP == f2) {
                    ++b;
                }
                if (b != 2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean renderBottomBelt(BlockEntity tile, Direction facing) {
        BlockEntity te = tile.m_58904_().m_7702_(tile.m_58899_().m_7918_(0, -1, 0));
        if (te instanceof ConveyorHandler.IConveyorBlockEntity && ((ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance() != null) {
            for (Direction f : ((ConveyorHandler.IConveyorBlockEntity)te).getConveyorInstance().sigTransportDirections()) {
                if (f != Direction.UP) continue;
                return false;
            }
        }
        for (Direction f : DirectionUtils.BY_HORIZONTAL_INDEX) {
            if (f == facing || !VerticalConveyor.isInwardConveyor(tile, f)) continue;
            return true;
        }
        return false;
    }

    record CoveredShapeKey(boolean bottomBelt, boolean leftWall, boolean rightWall, boolean frontConveyor) {
    }
}

