/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ThermoelectricGenBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE {
    private int energyOutput = -1;
    private final Map<Direction, CapabilityReference<IEnergyStorage>> energyWrappers = CapabilityReference.forAllNeighbors(this, ForgeCapabilities.ENERGY);
    private final Map<Direction, BiFunction<Level, Block, Integer>> temperatureGetters = new EnumMap<Direction, BiFunction<Level, Block, Integer>>(Direction.class);
    private final ResettableCapability<IEnergyStorage> energyCap;

    public ThermoelectricGenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.THERMOELECTRIC_GEN.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.temperatureGetters.put(d, CachedRecipe.cached(ThermoelectricSource::getSource).andThen(source -> source == null ? -1 : source.getTemperature()));
        }
        this.energyCap = this.registerCapability(NullEnergyStorage.INSTANCE);
    }

    @Override
    public void tickServer() {
        if (this.f_58857_.m_46467_() % 1024L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x3FF)) {
            this.recalculateEnergyOutput();
        }
        if (this.energyOutput > 0) {
            this.outputEnergy(this.energyOutput);
        }
    }

    public void outputEnergy(int amount) {
        for (Direction fd : DirectionUtils.VALUES) {
            IEnergyStorage forSide = this.energyWrappers.get(fd).getNullable();
            if (forSide == null) continue;
            amount -= forSide.receiveEnergy(amount, false);
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        super.onNeighborBlockChange(pos);
        this.recalculateEnergyOutput();
    }

    private void recalculateEnergyOutput() {
        int energy = 0;
        for (Direction fd : new Direction[]{Direction.DOWN, Direction.NORTH, Direction.WEST}) {
            if (this.f_58857_.m_46859_(this.m_58899_().m_121945_(fd)) || this.f_58857_.m_46859_(this.m_58899_().m_121945_(fd.m_122424_()))) continue;
            int temp0 = this.getTemperature(fd);
            int temp1 = this.getTemperature(fd.m_122424_());
            if (temp0 <= -1 || temp1 <= -1) continue;
            int diff = Math.abs(temp0 - temp1);
            energy += (int)(Math.sqrt(diff) / 2.0 * (Double)IEServerConfig.MACHINES.thermoelectric_output.get());
        }
        this.energyOutput = energy == 0 ? -1 : energy;
    }

    private int getTemperature(Direction offset) {
        BlockPos pos = this.f_58858_.m_121945_(offset);
        BlockState state = this.f_58857_.m_8055_(pos);
        FluidState f = state.m_60819_();
        if (!f.m_76178_()) {
            return f.getFluidType().getTemperature(f, (BlockAndTintGetter)this.f_58857_, pos);
        }
        return this.temperatureGetters.get(offset).apply(this.f_58857_, state.m_60734_());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.energyOutput = nbt.m_128451_("enegyOutput");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("enegyOutput", this.energyOutput);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

