/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BasicClientProperties
implements ClientMultiblocks.MultiblockManualData {
    private static final Map<ResourceLocation, DynamicModel> MODELS = new HashMap<ResourceLocation, DynamicModel>();
    private final IETemplateMultiblock multiblock;
    @Nullable
    private NonNullList<ItemStack> materials;
    private final Supplier<DynamicModel> model;
    private final Optional<Quaternion> rotation;

    public BasicClientProperties(IETemplateMultiblock multiblock) {
        this(multiblock, OptionalDouble.empty());
    }

    public BasicClientProperties(IETemplateMultiblock multiblock, OptionalDouble yRotationRadians) {
        this.multiblock = multiblock;
        this.model = Suppliers.memoize(() -> MODELS.get(multiblock.getUniqueName()));
        this.rotation = yRotationRadians.stream().mapToObj(r -> new Quaternion(0.0f, (float)r, 0.0f, false)).findAny();
    }

    public static void initModels() {
        for (MultiblockHandler.IMultiblock mb : IEMultiblocks.IE_MULTIBLOCKS) {
            if (!(mb instanceof IETemplateMultiblock)) continue;
            IETemplateMultiblock ieMB = (IETemplateMultiblock)mb;
            MODELS.put(mb.getUniqueName(), new DynamicModel(ieMB.getBlockName().m_135815_()));
        }
    }

    @Override
    public NonNullList<ItemStack> getTotalMaterials() {
        if (this.materials == null) {
            List<StructureTemplate.StructureBlockInfo> structure = this.multiblock.getStructure(null);
            this.materials = NonNullList.m_122779_();
            for (StructureTemplate.StructureBlockInfo info : structure) {
                if (info.f_74676_.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE) && ((Boolean)info.f_74676_.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) continue;
                ItemStack picked = Utils.getPickBlock(info.f_74676_);
                boolean added = false;
                for (ItemStack existing : this.materials) {
                    if (!ItemStack.m_41746_((ItemStack)existing, (ItemStack)picked)) continue;
                    existing.m_41769_(1);
                    added = true;
                    break;
                }
                if (added) continue;
                this.materials.add((Object)picked.m_41777_());
            }
        }
        return this.materials;
    }

    @Override
    public void renderFormedStructure(PoseStack transform, MultiBufferSource bufferSource) {
        transform.m_85836_();
        BlockPos offset = this.multiblock.getMasterFromOriginOffset();
        transform.m_85837_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        if (this.rotation.isPresent()) {
            transform.m_85837_(0.5, 0.0, 0.5);
            transform.m_85845_(this.rotation.get());
            transform.m_85837_(-0.5, 0.0, -0.5);
        }
        List<BakedQuad> nullQuads = this.model.get().getNullQuads();
        VertexConsumer buffer = bufferSource.m_6299_(IERenderTypes.TRANSLUCENT_FULLBRIGHT);
        nullQuads.forEach(quad -> buffer.m_85987_(transform.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_));
        transform.m_85849_();
    }

    @Override
    public boolean canRenderFormedStructure() {
        return true;
    }
}

