/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.lighting.QuadLighter;

public class ModelCoresample
extends BakedIEModel {
    private static final Cache<List<ResourceLocation>, ModelCoresample> modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    @Nullable
    private final MineralMix[] minerals;
    private List<BakedQuad> bakedQuads;
    private final ItemOverrides overrideList = new ItemOverrides(){

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int unused) {
            MineralMix[] minerals = CoresampleItem.getMineralMixes((Level)Minecraft.m_91087_().f_91073_, stack);
            if (minerals.length > 0) {
                try {
                    List<ResourceLocation> cacheKey = Arrays.stream(minerals).map(IESerializableRecipe::m_6423_).toList();
                    return (BakedModel)modelCache.get(cacheKey, () -> new ModelCoresample(minerals));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return originalModel;
        }
    };
    static HashMap<ItemTransforms.TransformType, Matrix4> transformationMap = new HashMap();

    public ModelCoresample(@Nullable MineralMix[] minerals) {
        this.minerals = minerals;
    }

    public static void clearCache() {
        modelCache.invalidateAll();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState coreState, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        MineralMix[] minerals = extraData.has(IEProperties.Model.MINERAL) ? (MineralMix[])extraData.get(IEProperties.Model.MINERAL) : this.minerals;
        if (this.bakedQuads == null || minerals == null) {
            this.bakedQuads = new ArrayList<BakedQuad>();
            Exception cause = null;
            try {
                float width = 0.25f;
                float depth = 0.25f;
                float wOff = (1.0f - width) / 2.0f;
                float dOff = (1.0f - depth) / 2.0f;
                int pixelLength = 0;
                ArrayList<Pair> textureOre = new ArrayList<Pair>();
                TextureAtlasSprite textureStone = null;
                if (minerals != null && minerals.length > 0) {
                    int allocatedPx = 16 / minerals.length;
                    for (MineralMix mineral : minerals) {
                        for (StackWithChance o : mineral.outputs) {
                            if (((ItemStack)o.stack().get()).m_41619_()) continue;
                            int weight = Math.round((float)allocatedPx * o.chance());
                            Block b = Block.m_49814_((Item)((ItemStack)o.stack().get()).m_41720_());
                            if (b == Blocks.f_50016_) {
                                b = mineral.background;
                            }
                            BlockState state = b.m_49966_();
                            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
                            textureOre.add(Pair.of((Object)model.m_6160_(), (Object)weight));
                            pixelLength += weight;
                        }
                        BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(mineral.background.m_49966_());
                        textureStone = model.m_6160_();
                    }
                } else {
                    pixelLength = 16;
                    textureStone = ClientUtils.getSprite(new ResourceLocation("block/stone"));
                }
                double[] stoneUVs = new double[]{16.0f * wOff, 16.0f * dOff, 16.0f * (wOff + width), 16.0f * (dOff + depth)};
                this.putVertexData(new Vec3(0.0, -1.0, 0.0), new Vec3[]{new Vec3((double)wOff, 0.0, (double)dOff), new Vec3((double)(wOff + width), 0.0, (double)dOff), new Vec3((double)(wOff + width), 0.0, (double)(dOff + depth)), new Vec3((double)wOff, 0.0, (double)(dOff + depth))}, stoneUVs, textureStone, this.bakedQuads);
                this.putVertexData(new Vec3(0.0, 1.0, 0.0), new Vec3[]{new Vec3((double)wOff, 1.0, (double)dOff), new Vec3((double)wOff, 1.0, (double)(dOff + depth)), new Vec3((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3((double)(wOff + width), 1.0, (double)dOff)}, stoneUVs, textureStone, this.bakedQuads);
                if (textureOre.isEmpty()) {
                    double[][] uvs = new double[4][];
                    for (int j = 0; j < 4; ++j) {
                        uvs[j] = new double[]{j * 4, 0.0, (j + 1) * 4, 16.0};
                    }
                    this.putVertexData(new Vec3(0.0, 0.0, -1.0), new Vec3[]{new Vec3((double)wOff, 0.0, (double)dOff), new Vec3((double)wOff, 1.0, (double)dOff), new Vec3((double)(wOff + width), 1.0, (double)dOff), new Vec3((double)(wOff + width), 0.0, (double)dOff)}, uvs[0], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3(0.0, 0.0, 1.0), new Vec3[]{new Vec3((double)(wOff + width), 0.0, (double)(dOff + depth)), new Vec3((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3((double)wOff, 1.0, (double)(dOff + depth)), new Vec3((double)wOff, 0.0, (double)(dOff + depth))}, uvs[2], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3(-1.0, 0.0, 0.0), new Vec3[]{new Vec3((double)wOff, 0.0, (double)(dOff + depth)), new Vec3((double)wOff, 1.0, (double)(dOff + depth)), new Vec3((double)wOff, 1.0, (double)dOff), new Vec3((double)wOff, 0.0, (double)dOff)}, uvs[3], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3(1.0, 0.0, 0.0), new Vec3[]{new Vec3((double)(wOff + width), 0.0, (double)dOff), new Vec3((double)(wOff + width), 1.0, (double)dOff), new Vec3((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3((double)(wOff + width), 0.0, (double)(dOff + depth))}, uvs[1], textureStone, this.bakedQuads);
                } else {
                    float h = 0.0f;
                    for (Pair pair : textureOre) {
                        TextureAtlasSprite sprite = (TextureAtlasSprite)pair.getFirst();
                        int weight = (Integer)pair.getSecond();
                        int v = weight > 8 ? 16 - weight : 8;
                        double[][] uvs = new double[4][];
                        for (int j = 0; j < 4; ++j) {
                            uvs[j] = new double[]{j * 4, v, (j + 1) * 4, v + weight};
                        }
                        float h1 = (float)weight / (float)pixelLength;
                        this.putVertexData(new Vec3(0.0, 0.0, -1.0), new Vec3[]{new Vec3((double)wOff, (double)h, (double)dOff), new Vec3((double)wOff, (double)(h + h1), (double)dOff), new Vec3((double)(wOff + width), (double)(h + h1), (double)dOff), new Vec3((double)(wOff + width), (double)h, (double)dOff)}, uvs[0], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3(0.0, 0.0, 1.0), new Vec3[]{new Vec3((double)(wOff + width), (double)h, (double)(dOff + depth)), new Vec3((double)(wOff + width), (double)(h + h1), (double)(dOff + depth)), new Vec3((double)wOff, (double)(h + h1), (double)(dOff + depth)), new Vec3((double)wOff, (double)h, (double)(dOff + depth))}, uvs[2], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3(-1.0, 0.0, 0.0), new Vec3[]{new Vec3((double)wOff, (double)h, (double)(dOff + depth)), new Vec3((double)wOff, (double)(h + h1), (double)(dOff + depth)), new Vec3((double)wOff, (double)(h + h1), (double)dOff), new Vec3((double)wOff, (double)h, (double)dOff)}, uvs[3], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3(1.0, 0.0, 0.0), new Vec3[]{new Vec3((double)(wOff + width), (double)h, (double)dOff), new Vec3((double)(wOff + width), (double)(h + h1), (double)dOff), new Vec3((double)(wOff + width), (double)(h + h1), (double)(dOff + depth)), new Vec3((double)(wOff + width), (double)h, (double)(dOff + depth))}, uvs[1], sprite, this.bakedQuads);
                        h += h1;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cause = e;
            }
            if (this.bakedQuads.isEmpty()) {
                if (cause != null) {
                    throw new RuntimeException("Empty quad list!", cause);
                }
                throw new RuntimeException("Empty quad list!");
            }
            return this.bakedQuads;
        }
        return this.bakedQuads;
    }

    protected final void putVertexData(Vec3 normal, Vec3[] vertices, double[] uvs, TextureAtlasSprite sprite, List<BakedQuad> out) {
        float d = QuadLighter.calculateShade((float)((float)normal.f_82479_), (float)((float)normal.f_82480_), (float)((float)normal.f_82481_), (boolean)false);
        BakedQuad quad = ModelUtils.createBakedQuad(vertices, Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_), sprite, uvs, new float[]{d, d, d, 1.0f}, false);
        out.add(quad);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    @Override
    public boolean m_7547_() {
        return false;
    }

    static {
        transformationMap.put(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemTransforms.TransformType.GUI, new Matrix4().scale(1.25, 1.25, 1.25).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(20.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-30.0), 0.0, 0.0, 1.0));
        transformationMap.put(ItemTransforms.TransformType.FIXED, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
        transformationMap.put(ItemTransforms.TransformType.GROUND, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
    }

    public static class CoresampleLoader
    implements IGeometryLoader<RawCoresampleModel> {
        public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "models/coresample");

        public RawCoresampleModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return new RawCoresampleModel();
        }
    }

    public static class RawCoresampleModel
    implements IUnbakedGeometry<RawCoresampleModel> {
        public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new ModelCoresample(null);
        }

        public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

