/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class MultitankArea
extends InfoArea {
    private final int capacity;
    private final Supplier<List<FluidStack>> getFluids;

    public MultitankArea(Rect2i area, int capacity, Supplier<List<FluidStack>> getFluids) {
        super(area);
        this.capacity = capacity;
        this.getFluids = getFluids;
    }

    @Override
    protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        if (this.getFluids().isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"gui.immersiveengineering.empty"));
        } else {
            int myRelative = this.area.m_110086_() + this.area.m_110091_() - mouseY;
            this.forEachFluid((fluid, lastY, newY) -> {
                if (myRelative >= lastY && myRelative < newY) {
                    FluidInfoArea.fillTooltip(fluid, this.capacity, tooltip::add);
                }
            });
        }
    }

    @Override
    public void draw(PoseStack transform) {
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.forEachFluid((fluid, lastY, newY) -> GuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffers, transform, fluid, this.area.m_110085_(), this.area.m_110086_() + this.area.m_110091_() - newY, this.area.m_110090_(), newY - lastY));
        buffers.m_109911_();
    }

    private void forEachFluid(TankVisitor visitor) {
        int fluidUpToNow = 0;
        int lastY = 0;
        List<FluidStack> fluids = this.getFluids();
        for (int i = fluids.size() - 1; i >= 0; --i) {
            FluidStack fs = fluids.get(i);
            if (fs.isEmpty()) continue;
            int newY = (int)((float)this.area.m_110091_() * ((float)(fluidUpToNow += fs.getAmount()) / (float)this.capacity));
            visitor.visit(fs, lastY, newY);
            lastY = newY;
        }
    }

    private List<FluidStack> getFluids() {
        return this.getFluids.get();
    }

    private static interface TankVisitor {
        public void visit(FluidStack var1, int var2, int var3);
    }
}

