/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ManualElementTable
extends SpecialManualElements {
    private final Component[][] table;
    private int[] bars;
    private final boolean horizontalBars;
    private OptionalInt height = OptionalInt.empty();
    private int[] textOff;

    @Deprecated
    public ManualElementTable(ManualInstance manual, String[][] table, boolean horizontalBars) {
        this(manual, (Component[][])Arrays.stream(table).map(a -> (Component[])Arrays.stream(a).map(Component::m_237113_).toArray(Component[]::new)).toArray(x$0 -> new Component[x$0][]), horizontalBars);
    }

    public ManualElementTable(ManualInstance manual, Component[][] table, boolean horizontalBars) {
        super(manual);
        Preconditions.checkNotNull((Object)table);
        this.table = table;
        this.horizontalBars = horizontalBars;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        super.onOpened(gui, x, y, pageButtons);
        try {
            this.recalculateLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        if (this.table != null) {
            int col = this.manual.getHighlightColour() | 0xFF000000;
            GuiComponent.m_93172_((PoseStack)transform, (int)x, (int)(y - 2), (int)(x + 120), (int)(y - 1), (int)col);
            Objects.requireNonNull(this.manual.fontRenderer());
            int lineHeight = 9;
            int yOff = 0;
            for (Component[] line : this.table) {
                if (line == null) continue;
                int height = 0;
                for (int j = 0; j < line.length; ++j) {
                    if (line[j] == null) continue;
                    int xx = this.textOff.length > 0 && j > 0 ? this.textOff[j - 1] : x;
                    int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] - x : 0));
                    Component lineText = line[j];
                    List lines = this.manual.fontRenderer().m_92923_((FormattedText)lineText, w);
                    for (int i = 0; i < lines.size(); ++i) {
                        this.manual.fontRenderer().m_92877_(transform, (FormattedCharSequence)lines.get(i), (float)xx, (float)(y + yOff + i * lineHeight), this.manual.getTextColour());
                    }
                    if (lines.size() <= height) continue;
                    height = lines.size();
                }
                if (this.horizontalBars) {
                    float scale = 0.5f;
                    transform.m_85841_(1.0f, scale, 1.0f);
                    int barHeight = (int)((float)(y + yOff + height * lineHeight) / scale);
                    GuiComponent.m_93172_((PoseStack)transform, (int)x, (int)barHeight, (int)(x + 120), (int)(barHeight + 1), (int)(this.manual.getTextColour() | 0xFF000000));
                    transform.m_85841_(1.0f, 1.0f / scale, 1.0f);
                }
                yOff += height * (lineHeight + 1);
            }
            if (this.bars != null) {
                for (int i = 0; i < this.bars.length; ++i) {
                    GuiComponent.m_93172_((PoseStack)transform, (int)(this.textOff[i] - 4), (int)(y - 4), (int)(this.textOff[i] - 3), (int)(y + yOff), (int)col);
                }
            }
        }
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    private void recalculateLayout() {
        this.bars = new int[1];
        for (Component[] tableLine : this.table) {
            if (tableLine.length - 1 > this.bars.length) {
                this.bars = Arrays.copyOf(this.bars, tableLine.length - 1);
            }
            for (int j = 0; j < tableLine.length - 1; ++j) {
                int fl = this.manual.fontRenderer().m_92852_((FormattedText)tableLine[j]);
                if (fl <= this.bars[j]) continue;
                this.bars[j] = fl;
            }
        }
        this.textOff = new int[this.bars.length];
        int xx = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            this.textOff[i] = xx += this.bars[i] + 8;
        }
        int yOff = 0;
        for (Component[] tableLine : this.table) {
            if (tableLine == null) continue;
            for (int j = 0; j < tableLine.length; ++j) {
                if (tableLine[j] == null) continue;
                int w = Math.max(10, 120 - (j > 0 ? this.textOff[j - 1] : 0));
                int l = this.manual.fontRenderer().m_92923_((FormattedText)tableLine[j], w).size();
                if (j == 0) continue;
                Objects.requireNonNull(this.manual.fontRenderer());
                yOff += l * (9 + 1);
            }
        }
        this.height = OptionalInt.of(yOff);
    }

    @Override
    public int getPixelsTaken() {
        if (!this.height.isPresent()) {
            this.recalculateLayout();
        }
        return this.height.getAsInt();
    }

    @Override
    public boolean isAbove() {
        return false;
    }
}

