/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.ShaderBagItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ShaderBagRecipe
extends CustomRecipe {
    public ShaderBagRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack stack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (!stack.m_41619_()) {
                return false;
            }
            Rarity rarity = stackInSlot.m_41791_();
            IEItems.ItemRegObject<ShaderBagItem> shaderBagForRarity = IEItems.Misc.SHADER_BAG.get(rarity);
            if (shaderBagForRarity != null && stackInSlot.m_150930_(shaderBagForRarity.m_5456_())) {
                stack = stackInSlot;
                continue;
            }
            return false;
        }
        return !stack.m_41619_();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            Rarity next = ShaderRegistry.getLowerRarity(stackInSlot.m_41791_());
            ItemStack output = new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(next), next != stackInSlot.m_41791_() ? 2 : 1);
            if (next == null) continue;
            ItemNBTHelper.putString(output, "rarity", next.toString());
            return output;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.COMMON), 2);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.SHADER_BAG_SERIALIZER.get();
    }
}

