/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class SlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB_CORNER -> SlabCornerSkipPredicate.testAgainstCorner(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> SlabCornerSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> SlabCornerSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SlabCornerSkipPredicate.testAgainstPillar(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> SlabCornerSkipPredicate.testAgainstDividedPanelVert(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabCornerSkipPredicate.testAgainstStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> SlabCornerSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> SlabCornerSkipPredicate.testAgainstVerticalDividedStairs(level, pos, state, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedPanelVert(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstPillar(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstPillar(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstEdge(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstPillar(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SlabCornerSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14418_(), side) || SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, top, (BlockState)states.m_14419_(), side);
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return CornerDir.fromDirections(side, dir, dir.m_122428_());
        }
        if (side == dir) {
            return CornerDir.fromDirections(side, dir.m_122428_(), top ? Direction.UP : Direction.DOWN);
        }
        if (side == dir.m_122428_()) {
            return CornerDir.fromDirections(side, dir, top ? Direction.UP : Direction.DOWN);
        }
        return CornerDir.NULL;
    }
}

