/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleHalfSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedDoubleHalfSlopeBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleHalfSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_HALF_SLOPE);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.RIGHT, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 hitVec = context.m_43720_();
        Direction dir = context.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        boolean right = Utils.fractionInDir(hitVec, dir.m_122427_()) > 0.5;
        state = (BlockState)state.m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right));
        return FramedDoubleHalfSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(facing));
        }
        if (face.m_122434_() == facing.m_122434_()) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.RIGHT);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_());
        }
        return (BlockState)state.m_61122_((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockItem createBlockItem() {
        return new VerticalAndWallBlockItem(this, (Block)FBContent.blockFramedVerticalDoubleHalfSlope.get(), new Item.Properties().m_41491_(FramedBlocks.FRAMED_TAB));
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.blockFramedHalfSlope.get()).m_49966_();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(!right))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleHalfSlopeBlockEntity(pos, state);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedDoubleHalfSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (((Boolean)state.m_61143_((Property)PropertyHolder.RIGHT)).booleanValue()) {
                dir = dir.m_122424_();
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedDoubleHalfSlope.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

