/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        if (((Boolean)state.m_61143_((Property)PropertyHolder.FRONT)).booleanValue()) {
            return false;
        }
        return side == state.m_61143_((Property)FramedProperties.FACING_HOR);
    };
    public static final Map<HorizontalRotation, VoxelShape> SHAPES = (Map)Util.m_137469_(new EnumMap(HorizontalRotation.class), map -> {
        map.put(HorizontalRotation.UP, Shapes.m_83124_((VoxelShape)FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).m_83296_());
        map.put(HorizontalRotation.RIGHT, Shapes.m_83124_((VoxelShape)FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).m_83296_());
        map.put(HorizontalRotation.DOWN, Shapes.m_83124_((VoxelShape)FramedSlopePanelBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)7.75), FramedSlopePanelBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)0.5)}).m_83296_());
        map.put(HorizontalRotation.LEFT, Shapes.m_83124_((VoxelShape)FramedSlopePanelBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)7.75), FramedSlopePanelBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)0.5)}).m_83296_());
    });

    public FramedSlopePanelBlock() {
        super(BlockType.FRAMED_SLOPE_PANEL);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, FramedProperties.GLOWING, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCross(context.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        boolean front = false;
        if (side.m_122434_() != facing.m_122434_()) {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = Utils.isX(facing) ? subHit.f_82479_ : subHit.f_82481_;
            front = xz < 0.5 == Utils.isPositive(facing);
        }
        BlockState state = (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front));
        return FramedSlopePanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face.m_122434_() == dir.m_122434_() || face == rotation.withFacing(dir)) {
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction side = Direction.UP;
        if (state.m_61143_(PropertyHolder.ROTATION) == HorizontalRotation.UP) {
            side = Direction.DOWN;
        }
        return this.rotate(state, side, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    public static BlockState mirrorPanel(BlockState state, Mirror mirror) {
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (newState != state && !rot.isVertical()) {
            state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot.getOpposite()));
        }
        return state;
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = SHAPES.get(state.m_61143_(PropertyHolder.ROTATION));
            if (((Boolean)state.m_61143_((Property)PropertyHolder.FRONT)).booleanValue()) {
                shape = shape.m_83216_(0.0, 0.0, 0.5);
            }
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

