/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.api.util.client.ModelCache;
import xfacthd.framedblocks.client.data.BlockOutlineRenderers;
import xfacthd.framedblocks.client.data.GhostRenderBehaviours;
import xfacthd.framedblocks.client.loader.overlay.OverlayLoader;
import xfacthd.framedblocks.client.model.FluidModel;
import xfacthd.framedblocks.client.model.FramedDoubleBlockModel;
import xfacthd.framedblocks.client.model.cube.FramedChestModel;
import xfacthd.framedblocks.client.model.cube.FramedCollapsibleBlockModel;
import xfacthd.framedblocks.client.model.cube.FramedCubeBaseModel;
import xfacthd.framedblocks.client.model.cube.FramedCubeModel;
import xfacthd.framedblocks.client.model.cube.FramedGlowingCubeModel;
import xfacthd.framedblocks.client.model.cube.FramedMarkedCubeModel;
import xfacthd.framedblocks.client.model.cube.FramedMiniCubeModel;
import xfacthd.framedblocks.client.model.cube.FramedOneWayWindowModel;
import xfacthd.framedblocks.client.model.cube.FramedTargetModel;
import xfacthd.framedblocks.client.model.door.FramedDoorModel;
import xfacthd.framedblocks.client.model.door.FramedFenceGateModel;
import xfacthd.framedblocks.client.model.door.FramedIronDoorModel;
import xfacthd.framedblocks.client.model.door.FramedIronTrapDoorModel;
import xfacthd.framedblocks.client.model.door.FramedTrapDoorModel;
import xfacthd.framedblocks.client.model.interactive.FramedButtonModel;
import xfacthd.framedblocks.client.model.interactive.FramedFlowerPotModel;
import xfacthd.framedblocks.client.model.interactive.FramedItemFrameModel;
import xfacthd.framedblocks.client.model.interactive.FramedLargeButtonModel;
import xfacthd.framedblocks.client.model.interactive.FramedLargeStoneButtonModel;
import xfacthd.framedblocks.client.model.interactive.FramedLeverModel;
import xfacthd.framedblocks.client.model.interactive.FramedMarkedPressurePlateModel;
import xfacthd.framedblocks.client.model.interactive.FramedPressurePlateModel;
import xfacthd.framedblocks.client.model.interactive.FramedSignModel;
import xfacthd.framedblocks.client.model.interactive.FramedStoneButtonModel;
import xfacthd.framedblocks.client.model.interactive.FramedWallSignModel;
import xfacthd.framedblocks.client.model.pane.FramedBarsModel;
import xfacthd.framedblocks.client.model.pane.FramedFloorModel;
import xfacthd.framedblocks.client.model.pane.FramedHorizontalPaneModel;
import xfacthd.framedblocks.client.model.pane.FramedPaneModel;
import xfacthd.framedblocks.client.model.pane.FramedWallBoardModel;
import xfacthd.framedblocks.client.model.pillar.FramedCornerPillarModel;
import xfacthd.framedblocks.client.model.pillar.FramedFenceModel;
import xfacthd.framedblocks.client.model.pillar.FramedHalfPillarModel;
import xfacthd.framedblocks.client.model.pillar.FramedLatticeModel;
import xfacthd.framedblocks.client.model.pillar.FramedPillarModel;
import xfacthd.framedblocks.client.model.pillar.FramedWallModel;
import xfacthd.framedblocks.client.model.prism.FramedInnerPrismModel;
import xfacthd.framedblocks.client.model.prism.FramedInnerSlopedPrismModel;
import xfacthd.framedblocks.client.model.prism.FramedPrismModel;
import xfacthd.framedblocks.client.model.prism.FramedSlopedPrismModel;
import xfacthd.framedblocks.client.model.rail.FramedFancyRailModel;
import xfacthd.framedblocks.client.model.rail.FramedRailSlopeModel;
import xfacthd.framedblocks.client.model.slab.FramedPanelModel;
import xfacthd.framedblocks.client.model.slab.FramedSlabCornerModel;
import xfacthd.framedblocks.client.model.slab.FramedSlabEdgeModel;
import xfacthd.framedblocks.client.model.slab.FramedSlabModel;
import xfacthd.framedblocks.client.model.slope.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.slope.FramedHalfSlopeModel;
import xfacthd.framedblocks.client.model.slope.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.slope.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.slope.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.slope.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.slope.FramedPyramidModel;
import xfacthd.framedblocks.client.model.slope.FramedPyramidSlabModel;
import xfacthd.framedblocks.client.model.slope.FramedSlopeModel;
import xfacthd.framedblocks.client.model.slope.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.model.slope.FramedVerticalHalfSlopeModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedExtendedSlopePanelModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatExtendedInnerSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatExtendedSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatInnerSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedElevatedSlopeSlabModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedFlatElevatedInnerSlopeSlabCornerModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedFlatElevatedSlopeSlabCornerModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedFlatInnerSlopeSlabCornerModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedFlatSlopeSlabCornerModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabModel;
import xfacthd.framedblocks.client.model.stairs.FramedHalfStairsModel;
import xfacthd.framedblocks.client.model.stairs.FramedLadderModel;
import xfacthd.framedblocks.client.model.stairs.FramedSlopedStairsModel;
import xfacthd.framedblocks.client.model.stairs.FramedStairsModel;
import xfacthd.framedblocks.client.model.stairs.FramedVerticalHalfStairsModel;
import xfacthd.framedblocks.client.model.stairs.FramedVerticalSlopedStairsModel;
import xfacthd.framedblocks.client.model.stairs.FramedVerticalStairsModel;
import xfacthd.framedblocks.client.model.torch.FramedRedstoneTorchModel;
import xfacthd.framedblocks.client.model.torch.FramedRedstoneWallTorchModel;
import xfacthd.framedblocks.client.model.torch.FramedSoulTorchModel;
import xfacthd.framedblocks.client.model.torch.FramedSoulWallTorchModel;
import xfacthd.framedblocks.client.model.torch.FramedTorchModel;
import xfacthd.framedblocks.client.model.torch.FramedWallTorchModel;
import xfacthd.framedblocks.client.render.BlockOutlineRenderer;
import xfacthd.framedblocks.client.render.FramedChestRenderer;
import xfacthd.framedblocks.client.render.FramedItemFrameRenderer;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.render.GhostBlockRenderer;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.screen.FramedStorageScreen;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.client.screen.overlay.FrameBackgroundOverlay;
import xfacthd.framedblocks.client.screen.overlay.OneWayWindowOverlay;
import xfacthd.framedblocks.client.screen.overlay.PrismOffsetOverlay;
import xfacthd.framedblocks.client.screen.overlay.ReinforcementOverlay;
import xfacthd.framedblocks.client.screen.overlay.SplitLineOverlay;
import xfacthd.framedblocks.client.screen.overlay.StateLockOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleWaterloggableOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleYSlopeOverlay;
import xfacthd.framedblocks.client.util.BlueprintPropertyOverride;
import xfacthd.framedblocks.client.util.ClientApiImpl;
import xfacthd.framedblocks.client.util.ClientEventHandler;
import xfacthd.framedblocks.client.util.DoubleBlockParticleMode;
import xfacthd.framedblocks.client.util.FramedBlockColor;
import xfacthd.framedblocks.client.util.FramedTargetBlockColor;
import xfacthd.framedblocks.client.util.KeyMappings;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedWeightedPressurePlateBlock;
import xfacthd.framedblocks.common.block.prism.FramedDoublePrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedDoubleSlopedPrismBlock;
import xfacthd.framedblocks.common.block.rail.FramedDetectorRailSlopeBlock;
import xfacthd.framedblocks.common.block.rail.FramedPoweredRailSlopeBlock;
import xfacthd.framedblocks.common.block.rail.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDividedSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoublePrismCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatInverseDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatStackedSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedStackedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatElevatedDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatInverseDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatStackedSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedStackedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.stairs.FramedDoubleStairsBlock;
import xfacthd.framedblocks.common.block.stairs.FramedVerticalDoubleStairsBlock;
import xfacthd.framedblocks.common.compat.supplementaries.SupplementariesCompat;
import xfacthd.framedblocks.common.data.BlockType;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FBContent.menuTypeFramedStorage.get()), FramedStorageScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FBContent.menuTypeFramingSaw.get()), FramingSawScreen::new);
            BlueprintPropertyOverride.register();
        });
        BlockOutlineRenderers.register();
        GhostBlockRenderer.init();
        GhostRenderBehaviours.register();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(KeyMappings::register);
        modBus.addListener(FramedSignScreen::onTextureStitch);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(ClientUtils::onClientTick);
        forgeBus.addListener(BlockOutlineRenderer::onRenderBlockHighlight);
        forgeBus.addListener(KeyMappings::onClientTick);
        forgeBus.addListener(GhostBlockRenderer::onRenderLevelStage);
        forgeBus.addListener(ClientEventHandler::onRecipesUpdated);
        forgeBus.addListener(ClientEventHandler::onClientDisconnect);
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        GhostBlockRenderer.lockRegistration();
        BlockOutlineRenderer.lockRegistration();
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)FBContent.blockEntityTypeFramedSign.get(), FramedSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)FBContent.blockEntityTypeFramedChest.get(), FramedChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)FBContent.blockEntityTypeFramedItemFrame.get(), FramedItemFrameRenderer::new);
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        Block[] blocks = (Block[])FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(IFramedBlock.class::isInstance).map(IFramedBlock.class::cast).filter(FBClient::useDefaultColorHandler).toArray(Block[]::new);
        event.register((BlockColor)FramedBlockColor.INSTANCE, blocks);
        event.register((BlockColor)FramedTargetBlockColor.INSTANCE, new Block[]{(Block)FBContent.blockFramedTarget.get()});
    }

    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)FramedTargetBlockColor.INSTANCE, new ItemLike[]{(ItemLike)FBContent.blockFramedTarget.get()});
    }

    @SubscribeEvent
    public static void onOverlayRegister(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("state_lock", (IGuiOverlay)new StateLockOverlay());
        event.registerAboveAll("toggle_waterloggable", (IGuiOverlay)new ToggleWaterloggableOverlay());
        event.registerAboveAll("y_slope", (IGuiOverlay)new ToggleYSlopeOverlay());
        event.registerAboveAll("reinforced", (IGuiOverlay)new ReinforcementOverlay());
        event.registerAboveAll("prism_offset", (IGuiOverlay)new PrismOffsetOverlay());
        event.registerAboveAll("split_line", (IGuiOverlay)new SplitLineOverlay());
        event.registerAboveAll("one_way_window", (IGuiOverlay)new OneWayWindowOverlay());
        event.registerAboveAll("frame_background", (IGuiOverlay)new FrameBackgroundOverlay());
    }

    @SubscribeEvent
    public static void onGeometryLoaderRegister(ModelEvent.RegisterGeometryLoaders event) {
        event.register(OverlayLoader.ID.m_135815_(), (IGeometryLoader)new OverlayLoader());
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(FluidModel.BARE_MODEL);
        event.register(FramedBlockModel.REINFORCEMENT_LOCATION);
        event.register(FramedMarkedCubeModel.SLIME_FRAME_LOCATION);
        event.register(FramedMarkedCubeModel.REDSTONE_FRAME_LOCATION);
        FramedMarkedPressurePlateModel.registerFrameModels(event);
        FramedStoneButtonModel.registerFrameModels(event);
        FramedLargeStoneButtonModel.registerFrameModels(event);
        event.register(FramedTargetModel.OVERLAY_LOCATION);
        if (SupplementariesCompat.isLoaded()) {
            event.register(SupplementariesCompat.HANGING_MODEL_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelEvent.BakingCompleted event) {
        Map registry = event.getModels();
        ModelCache.clear(event.getModelBakery());
        FramedChestRenderer.onModelsLoaded(registry);
        FramedBlockModel.captureReinforcementModel(event.getModels());
        FramedMarkedPressurePlateModel.cacheFrameModels(registry);
        FramedStoneButtonModel.cacheFrameModels(registry);
        FramedLargeStoneButtonModel.cacheFrameModels(registry);
        FramedTargetModel.cacheOverlayModel(registry);
        FramedOneWayWindowModel.captureTintedGlassModel(event.getModels());
        if (SupplementariesCompat.isLoaded()) {
            FramedFlowerPotModel.cacheHangingModel(registry);
        }
        List<BooleanProperty> ignoreWaterlogged = List.of(BlockStateProperties.f_61362_);
        List<BooleanProperty> ignoreWaterloggedLock = List.of(BlockStateProperties.f_61362_, FramedProperties.STATE_LOCKED);
        List<BooleanProperty> ignoreSolid = List.of(FramedProperties.SOLID, FramedProperties.GLOWING);
        List<BooleanProperty> ignoreDefault = List.of(BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING);
        List<BooleanProperty> ignoreDefaultLock = List.of(BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.STATE_LOCKED);
        Function<BlockState, BlockState> ignoreAll = state -> state.m_60734_().m_49966_();
        Function<BlockState, DoubleBlockParticleMode> particleTopFirstBottomSecond = state -> (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? DoubleBlockParticleMode.FIRST : DoubleBlockParticleMode.SECOND;
        Function<BlockState, DoubleBlockParticleMode> particleTopFirstElseEither = state -> (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? DoubleBlockParticleMode.FIRST : DoubleBlockParticleMode.EITHER;
        Vec3 yHalfUp = new Vec3(0.0, 0.5, 0.0);
        ClientUtils.replaceModels(FBContent.blockFramedCube, registry, FramedCubeModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedSlope, registry, FramedSlopeModel::new, FramedSlopeModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedCornerSlope, registry, FramedCornerSlopeModel::new, FramedCornerSlopeModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedInnerCornerSlope, registry, FramedInnerCornerSlopeModel::new, FramedInnerCornerSlopeModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedPrismCorner, registry, FramedPrismCornerModel::new, FramedPrismCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedInnerPrismCorner, registry, FramedInnerPrismCornerModel::new, FramedInnerPrismCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedThreewayCorner, registry, FramedThreewayCornerModel::new, FramedThreewayCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedInnerThreewayCorner, registry, FramedInnerThreewayCornerModel::new, FramedInnerThreewayCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedSlab, registry, FramedSlabModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedSlabEdge, registry, FramedSlabEdgeModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedSlabCorner, registry, FramedSlabCornerModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDividedSlab, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, null, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedPanel, registry, FramedPanelModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedCornerPillar, registry, FramedCornerPillarModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDividedPanelHor, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, null, ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDividedPanelVert, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, null, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedStairs, registry, FramedStairsModel::new, ignoreDefaultLock);
        ClientUtils.replaceModels(FBContent.blockFramedWall, registry, FramedWallModel::new, ignoreWaterloggedLock);
        ClientUtils.replaceModels(FBContent.blockFramedFence, registry, FramedFenceModel::createFenceModel, ignoreWaterloggedLock);
        ClientUtils.replaceModels(FBContent.blockFramedFenceGate, registry, FramedFenceGateModel::new, List.of(BlockStateProperties.f_61448_));
        ClientUtils.replaceModels(FBContent.blockFramedDoor, registry, FramedDoorModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedIronDoor, registry, FramedIronDoorModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedTrapDoor, registry, FramedTrapDoorModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedIronTrapDoor, registry, FramedIronTrapDoorModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedPressurePlate, registry, FramedPressurePlateModel::new, null);
        ClientUtils.reuseModels(FBContent.blockFramedWaterloggablePressurePlate, registry, FBContent.blockFramedPressurePlate, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedStonePressurePlate, registry, FramedMarkedPressurePlateModel::stone, null);
        ClientUtils.reuseModels(FBContent.blockFramedWaterloggableStonePressurePlate, registry, FBContent.blockFramedStonePressurePlate, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedObsidianPressurePlate, registry, FramedMarkedPressurePlateModel::obsidian, null);
        ClientUtils.reuseModels(FBContent.blockFramedWaterloggableObsidianPressurePlate, registry, FBContent.blockFramedObsidianPressurePlate, ignoreWaterlogged);
        ClientUtils.replaceModelsSpecial(FBContent.blockFramedGoldPressurePlate, registry, FramedMarkedPressurePlateModel::gold, FramedWeightedPressurePlateBlock::mergeWeightedState);
        ClientUtils.reuseModels(FBContent.blockFramedWaterloggableGoldPressurePlate, registry, FBContent.blockFramedGoldPressurePlate, ignoreWaterlogged);
        ClientUtils.replaceModelsSpecial(FBContent.blockFramedIronPressurePlate, registry, FramedMarkedPressurePlateModel::iron, FramedWeightedPressurePlateBlock::mergeWeightedState);
        ClientUtils.reuseModels(FBContent.blockFramedWaterloggableIronPressurePlate, registry, FBContent.blockFramedIronPressurePlate, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedLadder, registry, FramedLadderModel::new, FramedLadderModel.itemSource(), ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedButton, registry, FramedButtonModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedStoneButton, registry, FramedStoneButtonModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedLever, registry, FramedLeverModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedSign, registry, FramedSignModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedWallSign, registry, FramedWallSignModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleSlab, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, null, ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoublePanel, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, null, ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleSlope, (Map<ResourceLocation, BakedModel>)registry, FramedDoubleSlopeBlock::particleMode, FramedDoubleSlopeBlock.itemModelSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleCorner, (Map<ResourceLocation, BakedModel>)registry, FramedDoubleCornerBlock::particleMode, FramedDoubleCornerBlock.itemModelSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoublePrismCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstElseEither, FramedDoublePrismCornerBlock.itemModelSourcePrism(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleThreewayCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstElseEither, FramedDoubleThreewayCornerBlock.itemModelSourceThreeway(), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedTorch, registry, FramedTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedWallTorch, registry, FramedWallTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedSoulTorch, registry, FramedSoulTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedSoulWallTorch, registry, FramedSoulWallTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedRedstoneTorch, registry, FramedRedstoneTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedRedstoneWallTorch, registry, FramedRedstoneWallTorchModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedFloor, registry, FramedFloorModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedLattice, registry, FramedLatticeModel::new, ignoreWaterloggedLock);
        ClientUtils.replaceModels(FBContent.blockFramedVerticalStairs, registry, FramedVerticalStairsModel::new, ignoreDefaultLock);
        ClientUtils.replaceModels(FBContent.blockFramedChest, registry, FramedChestModel::new, FramedChestModel.itemSource(), ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedBars, registry, FramedBarsModel::new, ignoreWaterloggedLock);
        ClientUtils.replaceModels(FBContent.blockFramedPane, registry, FramedPaneModel::new, ignoreWaterloggedLock);
        ClientUtils.replaceModels(FBContent.blockFramedRailSlope, registry, FramedRailSlopeModel::normal, FramedRailSlopeModel.itemSourceNormal(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedPoweredRailSlope, registry, FramedRailSlopeModel::powered, FramedRailSlopeModel.itemSourcePowered(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedDetectorRailSlope, registry, FramedRailSlopeModel::detector, FramedRailSlopeModel.itemSourceDetector(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedActivatorRailSlope, registry, FramedRailSlopeModel::activator, FramedRailSlopeModel.itemSourceActivator(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlowerPot, registry, FramedFlowerPotModel::new, null);
        ClientUtils.replaceModels(FBContent.blockFramedPillar, registry, FramedPillarModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedHalfPillar, registry, FramedHalfPillarModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedPost, registry, FramedPillarModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedCollapsibleBlock, registry, FramedCollapsibleBlockModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedHalfStairs, registry, FramedHalfStairsModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDividedStairs, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, null, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedBouncyCube, registry, (state, baseModel) -> FramedMarkedCubeModel.slime(state, baseModel, registry), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedSecretStorage, registry, FramedCubeBaseModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedRedstoneBlock, registry, (state, baseModel) -> FramedMarkedCubeModel.redstone(state, baseModel, registry), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedPrism, registry, FramedPrismModel::new, FramedPrismModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedInnerPrism, registry, FramedInnerPrismModel::new, FramedInnerPrismModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoublePrism, (Map<ResourceLocation, BakedModel>)registry, FramedDoublePrismBlock::particleMode, FramedDoublePrismBlock.itemModelSource(), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedSlopedPrism, registry, FramedSlopedPrismModel::new, FramedSlopedPrismModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedInnerSlopedPrism, registry, FramedInnerSlopedPrismModel::new, FramedInnerSlopedPrismModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleSlopedPrism, (Map<ResourceLocation, BakedModel>)registry, FramedDoubleSlopedPrismBlock::particleMode, FramedDoubleSlopedPrismBlock.itemModelSource(), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedSlopeSlab, registry, FramedSlopeSlabModel::new, FramedSlopeSlabModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedElevatedSlopeSlab, registry, FramedElevatedSlopeSlabModel::new, FramedElevatedSlopeSlabModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleSlopeSlab, (Map<ResourceLocation, BakedModel>)registry, FramedDoubleSlopeSlabBlock::particleMode, yHalfUp, FramedDoubleSlopeSlabBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedInverseDoubleSlopeSlab, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, FramedInverseDoubleSlopeSlabBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedElevatedDoubleSlopeSlab, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedElevatedDoubleSlopeSlabBlock.itemModelSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedStackedSlopeSlab, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedStackedSlopeSlabBlock.itemModelSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatSlopeSlabCorner, registry, FramedFlatSlopeSlabCornerModel::new, FramedFlatSlopeSlabCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatInnerSlopeSlabCorner, registry, FramedFlatInnerSlopeSlabCornerModel::new, FramedFlatInnerSlopeSlabCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatElevatedSlopeSlabCorner, registry, FramedFlatElevatedSlopeSlabCornerModel::new, FramedFlatElevatedSlopeSlabCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatElevatedInnerSlopeSlabCorner, registry, FramedFlatElevatedInnerSlopeSlabCornerModel::new, FramedFlatElevatedInnerSlopeSlabCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatDoubleSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, yHalfUp, FramedFlatDoubleSlopeSlabCornerBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatInverseDoubleSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedFlatInverseDoubleSlopeSlabCornerBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatElevatedDoubleSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedFlatElevatedDoubleSlopeSlabCornerBlock.itemModelSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatElevatedInnerDoubleSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedFlatElevatedDoubleSlopeSlabCornerBlock.itemModelSourceInner(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatStackedSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedFlatStackedSlopeSlabCornerBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatStackedInnerSlopeSlabCorner, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstBottomSecond, FramedFlatStackedSlopeSlabCornerBlock.itemModelSourceInner(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedVerticalHalfStairs, registry, FramedVerticalHalfStairsModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedVerticalDividedStairs, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, null, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedSlopePanel, registry, FramedSlopePanelModel::new, FramedSlopePanelModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedExtendedSlopePanel, registry, FramedExtendedSlopePanelModel::new, FramedExtendedSlopePanelModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleSlopePanel, (Map<ResourceLocation, BakedModel>)registry, FramedDoubleSlopePanelBlock::particleMode, FramedDoubleSlopePanelBlock.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedInverseDoubleSlopePanel, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedInverseDoubleSlopePanelBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedExtendedDoubleSlopePanel, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedExtendedDoubleSlopePanelBlock.itemSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedStackedSlopePanel, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedStackedSlopePanelBlock.itemModelSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatSlopePanelCorner, registry, FramedFlatSlopePanelCornerModel::new, FramedFlatSlopePanelCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatInnerSlopePanelCorner, registry, FramedFlatInnerSlopePanelCornerModel::new, FramedFlatInnerSlopePanelCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatExtendedSlopePanelCorner, registry, FramedFlatExtendedSlopePanelCornerModel::new, FramedFlatExtendedSlopePanelCornerModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedFlatExtendedInnerSlopePanelCorner, registry, FramedFlatExtendedInnerSlopePanelCornerModel::new, FramedFlatExtendedInnerSlopePanelCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatDoubleSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, FramedFlatDoubleSlopePanelCornerBlock::particleMode, yHalfUp, FramedFlatDoubleSlopePanelCornerBlock.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatInverseDoubleSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, yHalfUp, FramedFlatInverseDoubleSlopePanelCornerBlock.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatExtendedDoubleSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedFlatExtendedDoubleSlopePanelCornerBlock.itemModelSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatExtendedInnerDoubleSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, FramedFlatExtendedDoubleSlopePanelCornerBlock::particleModeInner, FramedFlatExtendedDoubleSlopePanelCornerBlock.itemModelSourceInner(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatStackedSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedFlatStackedSlopePanelCornerBlock.itemModelSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFlatStackedInnerSlopePanelCorner, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedFlatStackedSlopePanelCornerBlock.itemModelSourceInner(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleStairs, (Map<ResourceLocation, BakedModel>)registry, particleTopFirstElseEither, FramedDoubleStairsBlock.itemSource(), ignoreSolid);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedVerticalDoubleStairs, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.EITHER, FramedVerticalDoubleStairsBlock.itemModelSource(), ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedWallBoard, registry, FramedWallBoardModel::new, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedGlowingCube, registry, FramedGlowingCubeModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedPyramid, registry, FramedPyramidModel::new, FramedPyramidModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedPyramidSlab, registry, FramedPyramidSlabModel::new, FramedPyramidSlabModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModelsSpecial(FBContent.blockFramedLargeButton, registry, FramedLargeButtonModel::new, FramedLargeButtonModel::mergeStates);
        ClientUtils.replaceModelsSpecial(FBContent.blockFramedLargeStoneButton, registry, FramedLargeStoneButtonModel::new, FramedLargeButtonModel::mergeStates);
        ClientUtils.replaceModels(FBContent.blockFramedHorizontalPane, registry, FramedHorizontalPaneModel::new, ignoreDefault);
        ClientUtils.replaceModelsSpecial(FBContent.blockFramedTarget, registry, FramedTargetModel::new, FramedTargetModel.itemSource(), ignoreAll);
        ClientUtils.replaceModels(FBContent.blockFramedGate, registry, FramedDoorModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedIronGate, registry, FramedIronDoorModel::new, ignoreSolid);
        ClientUtils.replaceModels(FBContent.blockFramedItemFrame, registry, FramedItemFrameModel::normal, null);
        ClientUtils.replaceModels(FBContent.blockFramedGlowingItemFrame, registry, FramedItemFrameModel::glowing, null);
        ClientUtils.replaceModels(FBContent.blockFramedFancyRail, registry, FramedFancyRailModel::normal, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedFancyPoweredRail, registry, FramedFancyRailModel::straight, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedFancyDetectorRail, registry, FramedFancyRailModel::straight, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedFancyActivatorRail, registry, FramedFancyRailModel::straight, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFancyRailSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.FIRST, FramedRailSlopeBlock.itemModelSourceFancy(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFancyPoweredRailSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.FIRST, FramedPoweredRailSlopeBlock.itemModelSourceFancyPowered(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFancyDetectorRailSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.FIRST, FramedDetectorRailSlopeBlock.itemModelSourceFancy(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedFancyActivatorRailSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.FIRST, FramedPoweredRailSlopeBlock.itemModelSourceFancyActivator(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedHalfSlope, registry, FramedHalfSlopeModel::new, FramedHalfSlopeModel.itemSource(), ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedVerticalHalfSlope, registry, FramedVerticalHalfSlopeModel::new, ignoreWaterlogged);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDividedSlope, (Map<ResourceLocation, BakedModel>)registry, FramedDividedSlopeBlock::particleMode, FramedDividedSlopeBlock.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedDoubleHalfSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, FramedDoubleHalfSlopeBlock.itemSource(), ignoreDefault);
        FBClient.replaceDoubleBlockModels(FBContent.blockFramedVerticalDoubleHalfSlope, (Map<ResourceLocation, BakedModel>)registry, DoubleBlockParticleMode.SECOND, null, ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedSlopedStairs, registry, FramedSlopedStairsModel::new, FramedSlopedStairsModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedVerticalSlopedStairs, registry, FramedVerticalSlopedStairsModel::new, FramedVerticalSlopedStairsModel.itemSource(), ignoreDefault);
        ClientUtils.replaceModels(FBContent.blockFramedMiniCube, registry, FramedMiniCubeModel::new, ignoreWaterlogged);
        ClientUtils.replaceModels(FBContent.blockFramedOneWayWindow, registry, FramedOneWayWindowModel::new, null);
    }

    @SubscribeEvent
    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)BlockInteractOverlay::onResourceReload));
    }

    private static void replaceDoubleBlockModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, DoubleBlockParticleMode particleMode, Vec3 firstpersonTransform, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        FBClient.replaceDoubleBlockModels(block, models, (BlockState state) -> particleMode, firstpersonTransform, itemModelSource, ignoredProps);
    }

    private static void replaceDoubleBlockModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, DoubleBlockParticleMode particleMode, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        FBClient.replaceDoubleBlockModels(block, models, (BlockState state) -> particleMode, null, itemModelSource, ignoredProps);
    }

    private static void replaceDoubleBlockModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, Function<BlockState, DoubleBlockParticleMode> particleMode, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        FBClient.replaceDoubleBlockModels(block, models, particleMode, null, itemModelSource, ignoredProps);
    }

    private static void replaceDoubleBlockModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, Function<BlockState, DoubleBlockParticleMode> particleMode, Vec3 firstpersonTransform, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        ClientUtils.replaceModels(block, models, (state, model) -> new FramedDoubleBlockModel((BlockState)state, (BakedModel)model, (DoubleBlockParticleMode)((Object)((Object)particleMode.apply((BlockState)state))), firstpersonTransform, itemModelSource != null), itemModelSource, ignoredProps);
    }

    private static boolean useDefaultColorHandler(IFramedBlock block) {
        IBlockType type = block.getBlockType();
        return type != BlockType.FRAMED_TARGET;
    }

    private FBClient() {
    }

    static {
        FramedBlocksClientAPI.INSTANCE.accept(new ClientApiImpl());
        RemovalCause.EXPLICIT.wasEvicted();
    }
}

